<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Api_model extends CI_Model {

/*Commom Fetch*/
function common_fetch($table,$where){
	$this->db->select()->from($table);
	$this->db->where($where);
    $this->db->order_by('id','desc');
	$query= $this->db->get();
    return $query->result_array();
	 
}
/*Commom Fetch*/

/*common insert*/
function common_insert($table,$data)
{
    $this->db->insert($table,$data);
    $id = $this->db->insert_id();
    return $id;
} 
/*common insert */

/*common update */
function common_update($table,$data,$where)
{
    $this->db->where($where);
    $this->db->update($table,$data);
    $id = $this->db->insert_id();
   return true;
   // return $this->db->last_query();
}
/*common update */

function products_fetch($cat_id)
{
    $this->db->select('products.*,products.id as product_id,units.unit_name');
    $this->db->from('products');
    $this->db->join('units','units.id = products.unit_id','left');
    if($cat_id != 0){
        $this->db->where('products.cat_id',$cat_id);
    }
    
    $this->db->where('products.delete_status','1');
    $query = $this->db->get();
    //$this->db->order_by('products.id','desc');
    return $query->result_array();
}


public function get_products_with_location_price($cat_id, $latitude, $longitude) {
    if (empty($latitude) || empty($longitude)) {
        return []; // Return empty array if coordinates are invalid
    }

    $sql = "
        SELECT 
            p.id AS product_id,
            p.product_image,
            p.product_quantity,
            p.description,
            p.product_name,
            COALESCE((
                SELECT pp.price
                FROM product_prices pp
                JOIN locations l ON l.id = pp.location_id
                WHERE pp.product_id = p.id
                AND (
                    6371 * ACOS(
                        COS(RADIANS(?)) * COS(RADIANS(l.latitude)) * COS(RADIANS(l.longitude) - RADIANS(?)) +
                        SIN(RADIANS(?)) * SIN(RADIANS(l.latitude))
                    )
                ) <= l.radius
                ORDER BY (
                    6371 * ACOS(
                        COS(RADIANS(?)) * COS(RADIANS(l.latitude)) * COS(RADIANS(l.longitude) - RADIANS(?)) +
                        SIN(RADIANS(?)) * SIN(RADIANS(l.latitude))
                    )
                ) ASC
                LIMIT 1
            ), p.product_price) AS product_price,
            u.unit_name
        FROM products p
        LEFT JOIN units u ON u.id = p.unit_id
        LEFT JOIN categories c ON c.id = p.cat_id AND c.delete_status = 1
        WHERE p.delete_status = 1 AND p.status = 1
    ";

    $bindValues = [
        $latitude, $longitude, $latitude,  // Subquery WHERE
        $latitude, $longitude, $latitude   // Subquery ORDER BY
    ];

    // 👇 Only add cat_id filter if it's not 0
    if ((int)$cat_id !== 0) {
        $sql .= " AND p.cat_id = ?";
        $bindValues[] = $cat_id;
    }else{
       $sql .= " AND c.delete_status = 1"; 
    }

    $sql .= " ORDER BY p.id";

    $query = $this->db->query($sql, $bindValues);
    return $query->result_array();
}



function fetch_single_product($product_id)
{
  $this->db->select('products.*,units.unit_name,categories.category_name');
  $this->db->from('products');
  $this->db->join('categories','categories.id = products.cat_id','left');
  $this->db->join('units','units.id = products.unit_id','left');
  $this->db->where('products.id',$product_id);
  $this->db->where('products.delete_status','1');
  $query = $this->db->get();
  return $query->result_array();
}

public function get_product_with_location_price($product_id, $latitude, $longitude) {
    // if (empty($latitude) || empty($longitude)) {
    //     return []; // Return empty array if coordinates are invalid
    // }

    // $sql = "
    //     SELECT 
    //         p.id AS product_id,
    //         p.product_image,
    //         p.product_quantity,
    //         p.description,
    //         p.product_name,
    //         COALESCE(location_price.price, p.product_price) AS product_price,
    //         u.unit_name,
    //         (6371 * ACOS(
    //             COS(RADIANS(?)) * COS(RADIANS(location_price.latitude)) * COS(RADIANS(location_price.longitude) - RADIANS(?)) +
    //             SIN(RADIANS(?)) * SIN(RADIANS(location_price.latitude))
    //         )) AS distance
    //     FROM products p
    //     LEFT JOIN units u ON u.id = p.unit_id
    //     LEFT JOIN (
    //         SELECT 
    //             pp.product_id,
    //             pp.price,
    //             l.latitude AS latitude,
    //             l.longitude AS longitude,
    //             l.radius
    //         FROM product_prices pp
    //         JOIN locations l ON l.id = pp.location_id
    //         WHERE (
    //             6371 * ACOS(
    //                 COS(RADIANS(?)) * COS(RADIANS(l.latitude)) * COS(RADIANS(l.longitude) - RADIANS(?)) +
    //                 SIN(RADIANS(?)) * SIN(RADIANS(l.latitude))
    //             )
    //         ) <= l.radius
    //         ORDER BY 
    //             (6371 * ACOS(
    //                 COS(RADIANS(?)) * COS(RADIANS(l.latitude)) * COS(RADIANS(l.longitude) - RADIANS(?)) +
    //                 SIN(RADIANS(?)) * SIN(RADIANS(l.latitude))
    //             )) ASC
    //         LIMIT 1
    //     ) location_price ON location_price.product_id = p.id
    //     WHERE p.delete_status = 1 AND p.id = ?
    //     ORDER BY p.id
    // ";

    // // Bind values
    // $bindValues = [
    //     $latitude, $longitude, $latitude, // Main Query
    //     $latitude, $longitude, $latitude, // Subquery 1
    //     $latitude, $longitude, $latitude, // Subquery Order By
    //     $product_id // Product ID Condition
    // ];

    // $query = $this->db->query($sql, $bindValues);

    // return $query->result_array(); // Return single product
    
    if (empty($latitude) || empty($longitude)) {
        return []; // Return empty array if coordinates are invalid
    }

    $sql = "
        SELECT 
            p.id AS product_id,
            p.product_image,
            p.product_quantity,
            p.description,
            p.product_name,
            COALESCE(pp.price, p.product_price) AS product_price,
            u.unit_name,
            l.latitude,
            l.longitude,
            l.radius,
            (
                6371 * ACOS(
                    COS(RADIANS(?)) * COS(RADIANS(l.latitude)) * COS(RADIANS(l.longitude) - RADIANS(?)) +
                    SIN(RADIANS(?)) * SIN(RADIANS(l.latitude))
                )
            ) AS distance
        FROM products p
        LEFT JOIN units u ON u.id = p.unit_id
        LEFT JOIN product_prices pp ON pp.product_id = p.id
        LEFT JOIN locations l ON l.id = pp.location_id
        WHERE p.delete_status = 1 AND p.id = ?
        ORDER BY distance ASC
        LIMIT 1
    ";

    $bindValues = [
        $latitude, $longitude, $latitude,
        $product_id
    ];

    $query = $this->db->query($sql, $bindValues);
    return $query->result_array();
}

public function get_wishlist_with_location_price($user_id, $latitude, $longitude) {
    if (empty($latitude) || empty($longitude)) {
        return []; // Return empty array if coordinates are invalid
    }

    $sql = "
        SELECT 
            p.id AS product_id,
            p.product_image,
            p.product_quantity,
            p.description,
            p.product_name,
            COALESCE((
                SELECT pp.price
                FROM product_prices pp
                JOIN locations l ON l.id = pp.location_id
                WHERE pp.product_id = p.id
                AND (
                    6371 * ACOS(
                        COS(RADIANS(?)) * COS(RADIANS(l.latitude)) * COS(RADIANS(l.longitude) - RADIANS(?)) +
                        SIN(RADIANS(?)) * SIN(RADIANS(l.latitude))
                    )
                ) <= l.radius
                ORDER BY (
                    6371 * ACOS(
                        COS(RADIANS(?)) * COS(RADIANS(l.latitude)) * COS(RADIANS(l.longitude) - RADIANS(?)) +
                        SIN(RADIANS(?)) * SIN(RADIANS(l.latitude))
                    )
                ) ASC
                LIMIT 1
            ), p.product_price) AS product_price,
            u.unit_name
        FROM user_wishlist w
        JOIN products p ON p.id = w.product_id
        LEFT JOIN units u ON u.id = p.unit_id
        LEFT JOIN categories c ON c.id = p.cat_id AND c.delete_status = 1
        WHERE p.delete_status = 1 AND w.user_id = ? AND  c.delete_status = 1
        ORDER BY p.id
    ";

    // Bind values in order
    $bindValues = [
        $latitude, $longitude, $latitude,   // Subquery WHERE
        $latitude, $longitude, $latitude,   // Subquery ORDER BY
        $user_id                            // Wishlist user_id
    ];

    $query = $this->db->query($sql, $bindValues);
    return $query->result_array();
}

public function get_cart_items_with_location_price($user_id, $latitude, $longitude) {
    if (empty($latitude) || empty($longitude)) {
        return []; // Return empty array if coordinates are invalid
    }

    $sql = "
        SELECT 
            w.*, 
            w.quantity AS cart_quantity,
            p.id AS product_id,
            p.product_image,
            p.product_quantity,
            p.description,
            p.product_name,
            COALESCE((
                SELECT pp.price
                FROM product_prices pp
                JOIN locations l ON l.id = pp.location_id
                WHERE pp.product_id = p.id
                AND (
                    6371 * ACOS(
                        COS(RADIANS(?)) * COS(RADIANS(l.latitude)) * COS(RADIANS(l.longitude) - RADIANS(?)) +
                        SIN(RADIANS(?)) * SIN(RADIANS(l.latitude))
                    )
                ) <= l.radius
                ORDER BY (
                    6371 * ACOS(
                        COS(RADIANS(?)) * COS(RADIANS(l.latitude)) * COS(RADIANS(l.longitude) - RADIANS(?)) +
                        SIN(RADIANS(?)) * SIN(RADIANS(l.latitude))
                    )
                ) ASC
                LIMIT 1
            ), p.product_price) AS product_price,
            u.unit_name
        FROM cart w
        JOIN products p ON p.id = w.product_id
        LEFT JOIN units u ON u.id = p.unit_id
        WHERE p.delete_status = 1 AND w.user_id = ?
        ORDER BY p.id
    ";

    // Bind values for COALESCE subquery (2x) and user_id
    $bindValues = [
        $latitude, $longitude, $latitude, // WHERE
        $latitude, $longitude, $latitude, // ORDER BY
        $user_id
    ];

    $query = $this->db->query($sql, $bindValues);

    return $query->result_array(); // Return cart items with accurate pricing
}



function get_cart_items($user_id)
{
    $this->db->select('cart.*,cart.quantity as cart_quantity,products.*,units.unit_name');
    $this->db->from('cart');
    $this->db->join('products','products.id = cart.product_id','left');
    $this->db->join('units','units.id = products.unit_id','left');
    $this->db->where('cart.user_id',$user_id);
    $this->db->where('products.delete_status','1');
    $query = $this->db->get();
    return $query->result_array();
    
}

function fetch_wishlist_items($user_id)
{
    $this->db->select('user_wishlist.*,products.*,units.unit_name');
    $this->db->from('user_wishlist');
    $this->db->join('products','products.id = user_wishlist.product_id','left');
    $this->db->join('units','units.id = products.unit_id','left');
    $this->db->where('user_wishlist.user_id',$user_id);
    $query = $this->db->get();
    return $query->result_array();
}


function get_distance($data)
{
    $this->db->select("COALESCE(( 6371 * acos( cos( radians({$data['latitude']}) ) * cos( radians( `latitude` ) ) * cos( radians( longitude ) - radians({$data['longitude']}) ) + sin( radians({$data['latitude']}) ) * sin( radians( `latitude` ) ) ) ), 0) AS distance, users.*", False);
    $this->db->from('users');
    $this->db->where('user_type','2');
    $this->db->where('users.db_status',1);
    $this->db->where('users.status',1);
    $this->db->where('users.delete_status',1);
    $this->db->where('users.duty_status',1);
    $this->db->where('users.delivery_boy_club',$data['club_id']);
    $this->db->order_by('distance','asc');
    //$this->db->where('distance <=',$distannce);
    $query = $this->db->get();
    return $query->result_array();
}
public function get_club_details($total_order_value)
{
    $this->db->select('clubs.id');
    $this->db->from('prices');
    $this->db->join('clubs','clubs.id = prices.club_id','left');
    $this->db->where('prices.price_range_from <=',$total_order_value);
    $this->db->where('prices.price_range_to >=',$total_order_value);
    $query = $this->db->get();
    return $query->result_array();
}

/*get single order details*/
public function get_order_details($order_id)
{
    $this->db->select('or.*,us.user_name as delivery_boy_name,us.user_mobile as delivery_boy_mobile,ad.*,us.upi_id,
    DATE_FORMAT(or.order_date,"%d-%m-%Y") as order_date, TIME_FORMAT(or.order_time,"%h:%i %p") as order_time');
    $this->db->from('orders or');
    $this->db->join('users us','us.id = or.delivery_boy_id','left');
    $this->db->join('user_addresses ad','ad.id = or.address_id','left');
    $this->db->where('or.order_id',$order_id);
    $query = $this->db->get();
    return $query->result_array();

}

public function get_order_details_db($order_id)
{
    $this->db->select('or.*,us.user_name,us.user_mobile,ad.*,us.upi_id,
    DATE_FORMAT(or.order_date,"%d-%m-%Y") as order_date, TIME_FORMAT(or.order_time,"%h:%i %p") as order_time');
    $this->db->from('orders or');
    $this->db->join('users us','us.id = or.user_id','left');
    $this->db->join('user_addresses ad','ad.id = or.address_id','left');
    $this->db->where('or.order_id',$order_id);
    $query = $this->db->get();
    return $query->result_array();

}
public function get_db_ongoing_order_details($delivery_boy_id,$user_id)
{
    $this->db->select('or.*,us.id as user_id,us.user_name,us.user_mobile,ad.*');
    $this->db->from('orders or');
     $this->db->join('users us','us.id = or.user_id','left');
   // $this->db->join('users us','us.id = or.delivery_boy_id','left');
    $this->db->join('user_addresses ad','ad.id = or.address_id','left');
   // $this->db->where('or.user_id',$user_id);
    $this->db->where('or.delivery_boy_id',$delivery_boy_id);
    $this->db->where('or.order_status !=', 'complaint');
    $this->db->where('or.order_status !=', 'delivered');
    $query = $this->db->get();
    return $query->result_array();
}

public function get_db_ongoing_order_details_db($delivery_boy_id)
{
    $this->db->select('or.*,us.user_name as delivery_boy_name,us.user_mobile as delivery_boy_mobile,
    DATE_FORMAT(or.order_date,"%d-%m-%Y") as order_date,TIME_FORMAT(or.order_time,"%h:%i %p") as order_time,
    DATE_FORMAT(or.created_on,"%d-%m-%Y %h:%i %p") as created_on');
    $this->db->from('orders or');
    $this->db->join('users us','us.id = or.delivery_boy_id','left');
  //  $this->db->join('user_addresses ad','ad.id = us.id AND ad.default_address = 1','left');
   // $this->db->where('or.user_id',$user_id);
    $this->db->where('or.delivery_boy_id',$delivery_boy_id);
    $this->db->where('or.order_status !=', 'complaint');
    $this->db->where('or.order_status !=', 'delivered');
    $query = $this->db->get();
    return $query->result_array();
}
public function get_user_details($order_id)
{
    $this->db->select('us.*,ad.*,us.id as user_id,us.user_name,us.user_mobile');
    $this->db->from('orders or');
    $this->db->join('users us','us.id = or.user_id','left');
    $this->db->join('user_addresses ad','ad.id = or.address_id','left');
   // $this->db->where('or.user_id',$user_id);
    $this->db->where('or.order_id',$order_id);
    $query = $this->db->get();
    return $query->result_array();
}
public function get_db_all_requests($delivery_boy_id)
{
    $this->db->select('dr.*,us.user_name,us.user_mobile,DATE_FORMAT(dr.created_on,"%d-%m-%Y %h:%i %p") as created_on,');
    $this->db->from('delivery_boy_requests dr');
    $this->db->join('users us','us.id = dr.user_id','left');
    $this->db->where('dr.delivery_boy_id',$delivery_boy_id);
    $this->db->where('dr.status','request');
    $query = $this->db->get();
    return $query->result_array();
}

public function get_order_items($order_id)
{
    $this->db->select('oi.*,pr.product_name ,pr.product_image , un.unit_name');
    $this->db->from('order_items oi');
    $this->db->join('products pr','pr.id = oi.product_id','left');
    $this->db->join('units un','un.id = pr.unit_id','left');
    $this->db->where('oi.order_id',$order_id);
    $query = $this->db->get();
    return $query->result_array();
}

public function get_order_status($order_id)
{
    $this->db->select('orders.order_status');
    $this->db->from('orders');
    $this->db->where('order_id',$order_id);
    $query = $this->db->get();
    return $query->result_array();

}

public function get_all_ongoing_orders($user_id)
{
    $this->db->select('orders.*,DATE_FORMAT(orders.order_date,"%d-%m-%Y") as order_date,TIME_FORMAT(orders.order_time,"%h:%i %p") as order_time');
    $this->db->from('orders');
    $this->db->where('user_id',$user_id);
     $this->db->group_start();
    $this->db->where('order_status !=','complaint');
    $this->db->where('order_status !=','delivered');
    $this->db->group_end();
    $query = $this->db->get();
    return $query->result_array();

}
/*get single order details*/


public function get_all_clubs($delivery_boy_id)
{
$this->db->select('clubs.*');
$this->db->from('clubs');
$this->db->join('users', 'users.delivery_boy_club = clubs.id AND users.id = ' . $delivery_boy_id, 'left');
$this->db->where('users.delivery_boy_club IS NULL'); // Exclude joined clubs
$this->db->where('clubs.delete_status',1); // Exclude joined clubs

$query = $this->db->get();
$result = $query->result_array();

return $result;
}
public function get_db_club($delivery_boy_id)
{
    $this->db->select('clubs.*');
$this->db->from('clubs');
$this->db->join('users','clubs.id = users.delivery_boy_club','left');
$this->db->where('users.id', $delivery_boy_id);
$query = $this->db->get();
$result = $query->result_array();
return $result;
}
public function get_all_notifications($user_id,$user_type,$date)
{
    $this->db->select('notifications.*,DATE_FORMAT(notifications.created_on,"%d-%m-%Y %H:%i:%s") as created_on');
$this->db->from('notifications');
$this->db->where('notifications.delete_status', 1);
$this->db->where('notifications.created_on >=', $date);

$this->db->group_start();
$this->db->where('notifications.user_id', $user_id);

$this->db->or_where('notifications.user_id',0);
 $this->db->group_end();
if($user_type == 1){
    $this->db->where('notifications.user_type', 'user');

}elseif($user_type == 2){
    $this->db->where('notifications.user_type', 'db');

}
$this->db->order_by('notifications.id','desc');
$query = $this->db->get();
$result = $query->result_array();
return $result;
}
public function get_user_all_details($user_mobile)
{
     $this->db->select('users.*,IFNULL(user_dob, "") AS user_dob');
$this->db->from('users');
//$this->db->join('users','clubs.id = users.delivery_boy_club','left');
$this->db->where('users.user_mobile', $user_mobile);
$query = $this->db->get();
$result = $query->result_array();
return $result;
}
public function get_only_critical_order_details($delivery_boy_id)
{
     $this->db->select('orders.*,DATE_FORMAT(orders.order_date,"%d-%m-%Y") as order_date,TIME_FORMAT(orders.order_time,"%h:%i %p") as order_time');
    $this->db->from('orders');
    $this->db->where('delivery_boy_id',$delivery_boy_id);
    // $this->db->group_start();
    $this->db->where('order_status','complaint');
    $this->db->where('complaint_status','critical');
  //  $this->db->group_end();
  $this->db->order_by('orders.id','desc');
    $query = $this->db->get();
    return $query->result_array();
}
public function get_db_order_details($delivery_boy_id)
{
     $this->db->select('orders.*,DATE_FORMAT(orders.order_date,"%d-%m-%Y") as order_date,TIME_FORMAT(orders.order_time,"%h:%i %p") as order_time');
    $this->db->from('orders');
    $this->db->where('delivery_boy_id',$delivery_boy_id);
    // $this->db->group_start();
    $this->db->where('order_status','delivered');
   // $this->db->where('complaint_status','critical');
  //  $this->db->group_end();
  $this->db->order_by('orders.id','desc');
    $query = $this->db->get();
    return $query->result_array();
}
public function get_db_complaint_order_details($delivery_boy_id)
{
   $this->db->select('orders.*,DATE_FORMAT(orders.order_date,"%d-%m-%Y") as order_date,TIME_FORMAT(orders.order_time,"%h:%i %p") as order_time');
    $this->db->from('orders');
    $this->db->where('delivery_boy_id',$delivery_boy_id);
    // $this->db->group_start();
    $this->db->where('order_status','complaint');
   // $this->db->where('complaint_status','critical');
  //  $this->db->group_end();
  $this->db->order_by('orders.id','desc');
    $query = $this->db->get();
    return $query->result_array(); 
}
public function get_user__order_history_details($user_id)
{
     $this->db->select('orders.*,DATE_FORMAT(orders.order_date,"%d-%m-%Y") as order_date,TIME_FORMAT(orders.order_time,"%h:%i %p") as order_time');
    $this->db->from('orders');
    $this->db->where('user_id',$user_id);
    // $this->db->group_start();
    $this->db->where('order_status','delivered');
   // $this->db->where('complaint_status','critical');
  //  $this->db->group_end();
  $this->db->order_by('orders.id','desc');
    $query = $this->db->get();
    return $query->result_array(); 
}

public function get_user_complaint_order_history_details($user_id)
{
     $this->db->select('orders.*,DATE_FORMAT(orders.order_date,"%d-%m-%Y") as order_date,TIME_FORMAT(orders.order_time,"%h:%i %p") as order_time');
    $this->db->from('orders');
    $this->db->where('user_id',$user_id);
    // $this->db->group_start();
    $this->db->where('order_status','complaint');
   // $this->db->where('complaint_status','critical');
  //  $this->db->group_end();
  $this->db->order_by('orders.id','desc');
    $query = $this->db->get();
    return $query->result_array(); 
}

// public function get_nearest_location($user_lat, $user_lng)
// {
//     $sql = "
//         SELECT *,
//         (
//             6371 * acos(
//                 cos(radians(?)) *
//                 cos(radians(latitude)) *
//                 cos(radians(longitude) - radians(?)) +
//                 sin(radians(?)) *
//                 sin(radians(latitude))
//             )
//         ) AS distance_km
//         FROM locations
//         WHERE delete_status = 1
//         HAVING radius <= range_km
//         ORDER BY radius ASC
//         LIMIT 1
//     ";

//     $query = $this->db->query($sql, array($user_lat, $user_lng, $user_lat));
//     return $query->row_array();  // return single row
// }
public function get_nearest_location_in_radius($user_lat, $user_lng)
{
    $sql = "
        SELECT *,
        (
            6371 * acos(
                cos(radians(?)) *
                cos(radians(latitude)) *
                cos(radians(longitude) - radians(?)) +
                sin(radians(?)) *
                sin(radians(latitude))
            )
        ) AS distance_km
        FROM locations
        WHERE delete_status = 1
        HAVING distance_km <= radius
        ORDER BY distance_km ASC
        LIMIT 1
    ";

    $query = $this->db->query($sql, array($user_lat, $user_lng, $user_lat));
    return $query->row_array(); // return one location
}




}
?>