<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin_model extends CI_Model {


    public function admin_login_verify($user_id,$password)
    {
        $this->db->select("*");
        $this->db->from("admin");
        $this->db->where("user_id",$user_id);
        $this->db->where("password",$password);
        $query = $this->db->get();
        return $query->result();
        
    }
    
    
    /*common fetch*/
    function common_fetch($table,$where){
	$this->db->select()->from($table);
	$this->db->where($where);
    $this->db->order_by('id','desc');
	$query= $this->db->get();
	return $query->result_array();
}
    /*common fetch*/
    
    
    /*common insert*/
function common_insert($table,$data)
{
    $this->db->insert($table,$data);
   $id = $this->db->insert_id();
    return $id;
} 
/*common insert */

/*common update */
function common_update($table,$data,$where)
{
    $this->db->where($where);
    $this->db->update($table,$data);
    
    return true;
}
/*common update */ 

function common_delete($table,$where)
{
    $this->db->where($where);
    $this->db->delete($table);
    
    return true;
}

/*prices fetching*/
function prices_fetch()
{
    $this->db->select('prices.*,clubs.club_name');
    $this->db->from('prices');
    $this->db->join('clubs','clubs.id = prices.club_id','left');
    $this->db->order_by('prices.id','desc');
    $query = $this->db->get();
    return $query->result_array();
}
/*prices fetching*/

/*products fetch*/

function products_fetch()
{
    $this->db->select('products.*,categories.category_name,units.unit_name');
    $this->db->from('products');
    $this->db->join('categories','categories.id = products.cat_id','left');
    $this->db->join('units','units.id = products.unit_id','left');
    $this->db->order_by('products.id','desc');
    $query = $this->db->get();
    return $query->result_array();
}


public function get_total_intrest_count()
{
    $this->db->select('*');
    $this->db->from('user_intrests');
    //$this->db->where('property_type','2');
    $query = $this->db->get();
return $query->num_rows();
}
/*dashboard fetching*/

 public function get_data($from_date, $to_date, $limit, $offset) {
        $this->db->select('*')->from('locations');
        if ($from_date && $to_date) {
           // $this->db->where('date >=', $from_date);
           // $this->db->where('date <=', $to_date);
        }
        $this->db->where('delete_status',1);
         $this->db->order_by('id','desc');
        $this->db->limit($limit, $offset);
        return $this->db->get()->result();
    }

    public function get_count($from_date, $to_date) {
        $this->db->select('id')->from('locations');
        if ($from_date && $to_date) {
           // $this->db->where('date >=', $from_date);
           // $this->db->where('date <=', $to_date);
        }
        $this->db->where('delete_status',1);
        return $this->db->count_all_results();
    }
    
    
    public function get_products_data($name, $limit, $offset) {
        
    //     $this->db->select('products.*,categories.category_name,units.unit_name');
    // $this->db->from('products');
    // $this->db->join('categories','categories.id = products.cat_id','left');
    // $this->db->join('units','units.id = products.unit_id','left');
    // $this->db->order_by('products.id','desc');
    // $query = $this->db->get();
    // return $query->result_array();
    
    
        $this->db->select('products.*,categories.category_name,units.unit_name');
    $this->db->from('products');
    $this->db->join('categories','categories.id = products.cat_id','left');
    $this->db->join('units','units.id = products.unit_id','left');
    if ($name) {
            $this->db->like('products.product_name', $name);
           // $this->db->where('date <=', $to_date);
        }
        $this->db->where('products.delete_status',1);
         $this->db->order_by('products.id','desc');
        $this->db->limit($limit, $offset);
        return $this->db->get()->result();
    }

    public function get_products_count($name) {
       $this->db->select('products.id');
    $this->db->from('products');
    $this->db->join('categories','categories.id = products.cat_id','left');
    $this->db->join('units','units.id = products.unit_id','left');
     if ( $name) {
          $this->db->like('products.product_name', $name);
          
           // $this->db->where('date >=', $from_date);
           // $this->db->where('date <=', $to_date);
        }
        $this->db->where('products.delete_status',1);
        return $this->db->count_all_results();
    }
 
    
    public function get_orders_data($from_date, $to_date, $limit, $offset)
    {
        $this->db->select('or.*,u.user_name,u.user_mobile,DATE_FORMAT(or.order_date,"%d-%m-%Y") as order_date')->from('orders or');
        $this->db->join('users u','u.id = or.user_id','left');
        if ($from_date && $to_date) {
            $this->db->where('or.order_date >=', $from_date);
            $this->db->where('or.order_date <=', $to_date);
        }
        $this->db->where('or.order_status','order_placed');
        $this->db->where('or.screen_shot','');
      
      //  $this->db->where('delete_status',1);
         $this->db->order_by('or.id','desc');
        $this->db->limit($limit, $offset);
        return $this->db->get()->result();
    }
    public function get_orders_count($from_date, $to_date)
    {
       $this->db->select('or.id')->from('orders or');
        if ($from_date && $to_date) {
            $this->db->where('or.order_date >=', $from_date);
            $this->db->where('or.order_date <=', $to_date);
        }
        $this->db->where('or.order_status','order_placed');
      //  $this->db->where('delete_status',1);
        return $this->db->count_all_results(); 
    }
    public function get_details_by_id($order_id)
    {
        $this->db->select('o.*,u.user_name,u.user_mobile,a.*');
        $this->db->from('orders o');
        $this->db->join('users u','u.id = o.user_id','left');
        $this->db->join('user_addresses a','a.id = o.address_id','left');
        $this->db->where('o.order_id', $order_id);
        $query = $this->db->get();
        return $query->result();
    }
    public function get_order_items($order_id)
    {
        $this->db->select('oi.*,p.product_name,p.product_image,u.*');
        $this->db->from('order_items oi');
        $this->db->join('products p','p.id = oi.product_id','left');
        $this->db->join('units u','u.id = p.unit_id','left');
        $this->db->where('oi.order_id', $order_id);
        $query = $this->db->get();
        return $query->result();
    }
    public function get_undelivered_orders_data($from_date, $to_date, $limit, $offset)
    {
        $this->db->select('or.*,u.user_name,u.user_mobile,DATE_FORMAT(or.order_date,"%d-%m-%Y") as order_date')->from('orders or');
        $this->db->join('users u','u.id = or.user_id','left');
        if ($from_date && $to_date) {
            $this->db->where('or.order_date >=', $from_date);
            $this->db->where('or.order_date <=', $to_date);
        }
        $this->db->group_start();
        $this->db->where('or.order_status','order_placed');
        $this->db->or_where('or.order_status','picked_up');
        $this->db->or_where('or.order_status','on_the_way');
        $this->db->group_end();
        
        $this->db->where('or.maintenance_fee_transaction_id','');
         $this->db->order_by('or.id','desc');
        $this->db->limit($limit, $offset);
        return $this->db->get()->result();
    }
    public function get_undelivered_orders_count($from_date, $to_date)
    {
       $this->db->select('or.id')->from('orders or');
        if ($from_date && $to_date) {
            $this->db->where('or.order_date >=', $from_date);
            $this->db->where('or.order_date <=', $to_date);
        }
       $this->db->group_start();
        $this->db->where('or.order_status','delivered');
        $this->db->or_where('or.order_status','picked_up');
        $this->db->or_where('or.order_status','on_the_way');
        $this->db->group_end();
         $this->db->where('or.maintenance_fee_transaction_id','');
       return $this->db->count_all_results(); 
    }
    
    public function get_delivered_orders_data($from_date, $to_date, $limit, $offset)
    {
        $this->db->select('or.*,u.user_name,u.user_mobile,DATE_FORMAT(or.order_date,"%d-%m-%Y") as order_date,
        DATE_FORMAT(or.delivered_date, "%d-%m-%Y %h:%i %p") AS delivered_date')->from('orders or');
        $this->db->join('users u','u.id = or.user_id','left');
        if ($from_date && $to_date) {
            $this->db->where('or.order_date >=', $from_date);
            $this->db->where('or.order_date <=', $to_date);
        }
       // $this->db->group_start();
        $this->db->where('or.order_status','delivered');
       // $this->db->or_where('or.order_status','pick_up');
       // $this->db->or_where('or.order_status','on_the_way');
        //$this->db->group_end();
        
        $this->db->where('or.maintenance_fee_transaction_id !=','');
         $this->db->order_by('or.id','desc');
        $this->db->limit($limit, $offset);
        return $this->db->get()->result();
    }
    public function get_delivered_orders_count($from_date, $to_date)
    {
       $this->db->select('or.id')->from('orders or');
        if ($from_date && $to_date) {
            $this->db->where('or.order_date >=', $from_date);
            $this->db->where('or.order_date <=', $to_date);
        }
      // $this->db->group_start();
        $this->db->where('or.order_status','delivered');
       // $this->db->or_where('or.order_status','pick_up');
       // $this->db->or_where('or.order_status','on_the_way');
        //$this->db->group_end();
         $this->db->where('or.maintenance_fee_transaction_id !=','');
       return $this->db->count_all_results(); 
    }
    
    public function get_complaint_orders_data($from_date, $to_date, $limit, $offset)
    {
        $this->db->select('or.*,u.user_name,u.user_mobile,DATE_FORMAT(or.order_date,"%d-%m-%Y") as order_date')->from('orders or');
        $this->db->join('users u','u.id = or.user_id','left');
        if ($from_date && $to_date) {
            $this->db->where('or.order_date >=', $from_date);
            $this->db->where('or.order_date <=', $to_date);
        }
       // $this->db->group_start();
        $this->db->where('or.order_status','complaint');
       // $this->db->or_where('or.order_status','pick_up');
       // $this->db->or_where('or.order_status','on_the_way');
        //$this->db->group_end();
        
       // $this->db->where('or.maintenance_fee_transaction_id !=','');
         $this->db->order_by('or.id','desc');
        $this->db->limit($limit, $offset);
        return $this->db->get()->result();
    }
    public function get_complaint_orders_count($from_date, $to_date)
    {
       $this->db->select('or.id')->from('orders or');
        if ($from_date && $to_date) {
            $this->db->where('or.order_date >=', $from_date);
            $this->db->where('or.order_date <=', $to_date);
        }
      // $this->db->group_start();
        $this->db->where('or.order_status','complaint');
       // $this->db->or_where('or.order_status','pick_up');
       // $this->db->or_where('or.order_status','on_the_way');
        //$this->db->group_end();
        // $this->db->where('or.maintenance_fee_transaction_id !=','');
       return $this->db->count_all_results(); 
    }
    
    
    public function get_cancel_orders_data($from_date, $to_date, $limit, $offset)
    {
        $this->db->select('or.*,u.user_name,u.user_mobile,DATE_FORMAT(or.order_date,"%d-%m-%Y") as order_date,
        DATE_FORMAT(or.order_time, "%h:%i %p") AS order_time, DATE_FORMAT(or.cancel_date, "%d-%m-%Y %h:%i %p") AS cancel_date
        ')->from('orders or');
        $this->db->join('users u','u.id = or.user_id','left');
        if ($from_date && $to_date) {
            $this->db->where('or.order_date >=', $from_date);
            $this->db->where('or.order_date <=', $to_date);
        }
       // $this->db->group_start();
        $this->db->where('or.order_status','cancel');
       // $this->db->or_where('or.order_status','pick_up');
       // $this->db->or_where('or.order_status','on_the_way');
        //$this->db->group_end();
        
       // $this->db->where('or.maintenance_fee_transaction_id !=','');
         $this->db->order_by('or.id','desc');
        $this->db->limit($limit, $offset);
        return $this->db->get()->result();
    }
    public function get_cancel_orders_count($from_date, $to_date)
    {
       $this->db->select('or.id')->from('orders or');
        if ($from_date && $to_date) {
            $this->db->where('or.order_date >=', $from_date);
            $this->db->where('or.order_date <=', $to_date);
        }
      // $this->db->group_start();
        $this->db->where('or.order_status','cancel');
       // $this->db->or_where('or.order_status','pick_up');
       // $this->db->or_where('or.order_status','on_the_way');
        //$this->db->group_end();
        // $this->db->where('or.maintenance_fee_transaction_id !=','');
       return $this->db->count_all_results(); 
    }
    
    
    
    
    
    public function get_users_data($user_name, $limit, $offset)
    {
        $this->db->select('u.*,DATE_FORMAT(u.created_on,"%d-%m-%Y") as created_on')->from('users u');
        if ($user_name) {
            $this->db->like('u.user_name', $user_name);
        
           // $this->db->where('u.user_name', $user_name);
            //$this->db->where('u.created_on <=', $to_date);
        }
       // $this->db->group_start();
      //  $this->db->where('or.order_status','complaint');
       // $this->db->or_where('or.order_status','pick_up');
       // $this->db->or_where('or.order_status','on_the_way');
        //$this->db->group_end();
        $this->db->where('u.user_type','1');
        $this->db->where('u.delete_status','1');
         $this->db->order_by('u.id','desc');
        $this->db->limit($limit, $offset);
        return $this->db->get()->result();
    }
    public function get_users_count($user_name)
    {
       $this->db->select('u.id')->from('users u');
        if ($user_name) {
            $this->db->like('u.user_name', $user_name);
            //$this->db->where('u.user_name', $user_name);
           // $this->db->where('u.created_on <=', $to_date);
        }
      // $this->db->group_start();
      $this->db->where('u.user_type','1');
         $this->db->where('u.delete_status','1');
       // $this->db->or_where('or.order_status','pick_up');
       // $this->db->or_where('or.order_status','on_the_way');
        //$this->db->group_end();
        // $this->db->where('or.maintenance_fee_transaction_id !=','');
       return $this->db->count_all_results(); 
    }
    
    public function get_db_data($user_name, $limit, $offset)
    {
        $this->db->select('u.*,DATE_FORMAT(u.created_on,"%d-%m-%Y") as created_on,
        DATE_FORMAT(u.user_dob,"%d-%m-%Y") as user_dob,IFNULL(c.club_name, "") AS club_name,
            CASE 
        WHEN u.duty_status = 1 THEN "On"
        ELSE "Off" 
    END as db_duty_status
        ',FALSE)->from('users u');
        $this->db->join('clubs c','c.id = u.delivery_boy_club','left');
        if ($user_name) {
            $this->db->like('u.user_name', $user_name);
        
           // $this->db->where('u.user_name', $user_name);
            //$this->db->where('u.created_on <=', $to_date);
        }
       // $this->db->group_start();
      //  $this->db->where('or.order_status','complaint');
       // $this->db->or_where('or.order_status','pick_up');
       // $this->db->or_where('or.order_status','on_the_way');
        //$this->db->group_end();
        $this->db->where('u.user_type','2');
        $this->db->where('u.delete_status','1');
         $this->db->order_by('u.id','desc');
        $this->db->limit($limit, $offset);
        return $this->db->get()->result();
    }
    public function get_db_count($user_name)
    {
       $this->db->select('u.id')->from('users u');
        if ($user_name) {
            $this->db->like('u.user_name', $user_name);
            //$this->db->where('u.user_name', $user_name);
           // $this->db->where('u.created_on <=', $to_date);
        }
      // $this->db->group_start();
      $this->db->where('u.user_type','2');
         $this->db->where('u.delete_status','1');
       // $this->db->or_where('or.order_status','pick_up');
       // $this->db->or_where('or.order_status','on_the_way');
        //$this->db->group_end();
        // $this->db->where('or.maintenance_fee_transaction_id !=','');
       return $this->db->count_all_results(); 
    }
    
    public function get_db_clubs_data($club, $limit, $offset)
    {
        $this->db->select('u.user_name,u.user_mobile,dc.status,u.id,c.advance_amount,
        DATE_FORMAT(dc.joining_date,"%d-%m-%Y") as joining_date,IFNULL(c.club_name, "") AS club_name')->from('users u');
        $this->db->join('clubs c','c.id = u.delivery_boy_club','inner');
        $this->db->join('db_joined_withdrawn_clubs dc','dc.db_id = u.id AND dc.club_id = u.delivery_boy_club AND dc.status = "join" ','inner');
        
        if ($club) {
            $this->db->where('u.delivery_boy_club', $club);
        
           // $this->db->where('u.user_name', $user_name);
            //$this->db->where('u.created_on <=', $to_date);
        }
       // $this->db->group_start();
      //  $this->db->where('or.order_status','complaint');
       // $this->db->or_where('or.order_status','pick_up');
       // $this->db->or_where('or.order_status','on_the_way');
        //$this->db->group_end();
        $this->db->where('u.user_type','2');
        $this->db->where('u.delete_status','1');
         $this->db->order_by('u.id','desc');
        $this->db->limit($limit, $offset);
        return $this->db->get()->result();
    }
    public function get_db_clubs_count($club)
    {
       $this->db->select('u.id')->from('users u');
        $this->db->join('clubs c','c.id = u.delivery_boy_club','inner');
        $this->db->join('db_joined_withdrawn_clubs dc','dc.db_id = u.id AND dc.club_id = u.delivery_boy_club AND dc.status = "join" ','inner');
       
        if ($club) {
            $this->db->where('u.delivery_boy_club', $club);
            //$this->db->where('u.user_name', $user_name);
           // $this->db->where('u.created_on <=', $to_date);
        }
      // $this->db->group_start();
      $this->db->where('u.user_type','2');
         $this->db->where('u.delete_status','1');
       // $this->db->or_where('or.order_status','pick_up');
       // $this->db->or_where('or.order_status','on_the_way');
        //$this->db->group_end();
        // $this->db->where('or.maintenance_fee_transaction_id !=','');
       return $this->db->count_all_results(); 
    }
    
    public function get_db_club_withdraw_data($user_name, $limit, $offset)
    {
    //     $this->db->select('u.*,DATE_FORMAT(dc.withdrawn_date,"%d-%m-%Y") as withdrawn_date,dc.*,c.*,
    //     DATE_FORMAT(u.user_dob,"%d-%m-%Y") as user_dob,IFNULL(c.club_name, "") AS club_name,
    //         SUM(CASE WHEN o.maintenance_fee_transaction_id = ""  THEN o.maintenance_charges ELSE 0 END) AS pending_maintenance_charges,
    //     ');
    //     $this->db->from('db_joined_withdrawn_clubs dc');
    //     $this->db->join('clubs c','c.id = dc.club_id','left');
    //     $this->db->join('users u','u.id = dc.db_id','left');
    //         $this->db->join('orders o', 'dc.db_id = o.delivery_boy_id', 'left');

    //     if ($user_name) {
    //         $this->db->like('u.user_name', $user_name);
        
    //       // $this->db->where('u.user_name', $user_name);
    //         //$this->db->where('u.created_on <=', $to_date);
    //     }
       
    //     $this->db->where('dc.status','withdraw');
    //   // $this->db->where('u.delete_status','1');
    //      $this->db->order_by('u.id','desc');
    //     $this->db->limit($limit, $offset);
    //     return $this->db->get()->result();
    
   $this->db->select('dc.id as dc_id,
    u.user_name, 
    u.user_mobile, 
    DATE_FORMAT(dc.withdrawn_date, "%d-%m-%Y") as withdrawn_date,
    dc.db_id, 
    dc.withdrawn_date, 
    dc.status, 
    DATE_FORMAT(u.user_dob, "%d-%m-%Y") as user_dob,
    IFNULL(c.club_name, "") AS club_name,c.advance_amount,
    SUM(
        CASE 
            WHEN o.maintenance_fee_transaction_id IS NULL OR o.maintenance_fee_transaction_id = "" 
            THEN o.maintenance_charges 
            ELSE 0 
        END
    ) AS pending_maintenance_charges
', false);

$this->db->from('db_joined_withdrawn_clubs dc');
$this->db->join('clubs c', 'c.id = dc.club_id', 'left');
$this->db->join('users u', 'u.id = dc.db_id', 'left');
$this->db->join('orders o', 'dc.db_id = o.delivery_boy_id', 'left');
$this->db->where('dc.status', 'withdraw');
$this->db->group_by([
    'u.id', 'u.user_name', 'u.user_mobile',
    'dc.withdrawn_date', 'dc.db_id', 'dc.status',
    'c.club_name', 'u.user_dob', 'c.advance_amount','dc.id'
]);
$this->db->order_by('u.id', 'desc');
$this->db->limit($limit, $offset);

return $this->db->get()->result();


    }
    public function get_db_club_withdraw_count($user_name)
    {
       $this->db->select('u.id');
       $this->db->from('db_joined_withdrawn_clubs dc');
       $this->db->join('clubs c','c.id = dc.club_id','left');
        $this->db->join('users u','u.id = dc.db_id','left');
        if ($user_name) {
            $this->db->like('u.user_name', $user_name);
            //$this->db->where('u.user_name', $user_name);
           // $this->db->where('u.created_on <=', $to_date);
        }
        $this->db->where('dc.status','withdraw');
      // $this->db->group_start();
      //$this->db->where('u.user_type','2');
       //  $this->db->where('u.delete_status','1');
       return $this->db->count_all_results(); 
    }
    
    public function get_db_refund_data($user_name, $limit, $offset)
    {
        $this->db->select('dc.*,c.*,u.*,DATE_FORMAT(u.created_on,"%d-%m-%Y") as created_on,dc.status as refund_status,
        DATE_FORMAT(dc.refunded_date,"%d-%m-%Y") as refunded_date,IFNULL(c.club_name, "") AS club_name');
        $this->db->from('db_joined_withdrawn_clubs dc');
        $this->db->join('clubs c','c.id = dc.club_id','left');
        $this->db->join('users u','u.id = dc.db_id','left');
        if ($user_name) {
            $this->db->like('u.user_name', $user_name);
        
           // $this->db->where('u.user_name', $user_name);
            //$this->db->where('u.created_on <=', $to_date);
        }
       
        $this->db->where('dc.status','refunded');
       // $this->db->where('u.delete_status','1');
         $this->db->order_by('u.id','desc');
        $this->db->limit($limit, $offset);
        return $this->db->get()->result();
    }
    public function get_db_refund_count($user_name)
    {
       $this->db->select('u.id');
       $this->db->from('db_joined_withdrawn_clubs dc');
       $this->db->join('clubs c','c.id = dc.club_id','left');
        $this->db->join('users u','u.id = dc.db_id','left');
        if ($user_name) {
            $this->db->like('u.user_name', $user_name);
            //$this->db->where('u.user_name', $user_name);
           // $this->db->where('u.created_on <=', $to_date);
        }
        $this->db->where('dc.status','refunded');
      // $this->db->group_start();
      //$this->db->where('u.user_type','2');
       //  $this->db->where('u.delete_status','1');
       return $this->db->count_all_results(); 
    }
    public function location_product_prices($id)
    {
         // Change this to your dynamic product ID

$this->db->select('locations.id as location_id, locations.name as location_name, COALESCE(product_prices.price, 0) as price');
$this->db->from('locations');
$this->db->join('product_prices', 'locations.id = product_prices.location_id AND product_prices.product_id = ' . (int)$id, 'left');
$this->db->where('locations.delete_status',1);
$query = $this->db->get();

$result = $query->result_array();
return $result;
    }
    
    public function get_total_joinings()
    {
        $this->db->select("
        COUNT(*) AS total_count,
        COUNT(CASE WHEN user_type = '1' THEN 1 END) AS user_count,
        COUNT(CASE WHEN user_type = '2' THEN 1 END) AS deliveryboy_count
        ");
        $this->db->from('users');
        $this->db->where('delete_status',1);
       $query = $this->db->get();
       $result = $query->row();
        return $result;
     }
    
    public function get_total_orders()
    {
        $this->db->select("COUNT(*) AS total_orders");
        $this->db->from("orders");
         $query = $this->db->get();
       $result = $query->row();
        return $result;
        
    }
    public function get_clubs_db_count()
    {
        $this->db->select("c.*,COUNT(u.id) AS total_db_joined");
        $this->db->from("clubs c");
        $this->db->join("users u","u.delivery_boy_club = c.id","left");
        $this->db->group_by(['c.id', 'c.club_name']);
        $query = $this->db->get();
        $result = $query->result();
        return $result;
    }
    public function get_total_maintenance($club_id)
    {
        $this->db->select("IFNULL(SUM(o.maintenance_charges), 0) AS total_maintenace");
        $this->db->from("orders o");
        $this->db->where("o.club_id",$club_id);
        $this->db->group_start();
        $this->db->where("o.order_status","delivered");
        $this->db->or_where("o.order_status","complaint");
        $this->db->group_end();
        $this->db->where("o.maintenance_fee_transaction_id !=","");
         $query = $this->db->get();
       $result = $query->row();
        return $result;
        
    }
    
    public function get_conatct_us_data($from_date, $to_date, $limit, $offset) {
        $this->db->select('c.*,u.user_name,DATE_FORMAT(c.created_on,"%d-%m-%Y") as created_on')->from('contact_us c');
        $this->db->join('users u','u.id = c.user_id','left');
        if ($from_date && $to_date) {
           // $this->db->where('date >=', $from_date);
           // $this->db->where('date <=', $to_date);
        }
        $this->db->where('c.delete_status',1);
         $this->db->order_by('c.id','desc');
        $this->db->limit($limit, $offset);
        return $this->db->get()->result();
    }

    public function ge_conatct_us_count($from_date, $to_date) {
        $this->db->select('id')->from('contact_us');
        if ($from_date && $to_date) {
           // $this->db->where('date >=', $from_date);
           // $this->db->where('date <=', $to_date);
        }
        $this->db->where('delete_status',1);
        return $this->db->count_all_results();
    }
 


   

   
}