<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Orders extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/userguide3/general/urls.html
	 */

     public function __construct(){
        parent::__construct();
        
        $this->load->model('admin/admin_model','admin_model');
        $this->load->library('session');
date_default_timezone_set("Asia/Kolkata");
        if (!($this->session->userdata('admin_id')))
			{
				//$this->load->view('admin/login');
				redirect('admin/login','refresh');
			}
      }
      
       public function sendNotification($playerId, $title, $message, $user_type = null) {
    $appId = '1ad1bebd-28dd-47d6-b471-98bc6d9531b8'; // Replace with your OneSignal App ID
    $apiKey = 'os_v2_app_dli35pji3vd5nndrtc6g3fjrxbsekwdb4oauhdeiq3xmzqhnsfalmohwdceqvu25e2mbglzdhrsixb22jnqfyguqwec3kkwjyuwsrra'; // Replace with your OneSignal REST API Key
    
    $curl = curl_init();

    // Common notification data
    $notificationData = [
        "app_id" => $appId,
        "headings" => ["en" => $title], // Notification title
        "contents" => ["en" => $message], // Notification content
        "small_icon" => "gross_bytes_logo", // Android Small Icon (Place inside res/drawable),
    ];

    // 1️⃣ *Sending to ALL Users*
    if ($playerId === 'all') {
        //$notificationData["included_segments"] = ["All"]; // Send to all users
        $notificationData["filters"] = [
            ["field" => "tag", "key" => "user_type", "relation" => "=", "value" => $user_type]
        ];
    
    // 2️⃣ *Sending to a Filtered User Type (e.g., Only Employees or Only Users)*
    } /*elseif ($userType !== null) {
        
    
    // 3️⃣ *Sending to Multiple Specific Users*
    }*/ elseif (is_array($playerId)) {
        $notificationData["include_player_ids"] = $playerId; // Send to multiple users
    
    // 4️⃣ *Sending to a Single User*
    } else {
        $notificationData["include_player_ids"] = [$playerId]; // Send to a single user
    }

    curl_setopt_array($curl, [
        CURLOPT_URL => "https://onesignal.com/api/v1/notifications",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => json_encode($notificationData),
        CURLOPT_HTTPHEADER => [
            "Authorization: Key $apiKey", // API Key in Authorization header
            "Content-Type: application/json"
        ],
        CURLOPT_SSL_VERIFYPEER => false, // Disable SSL verification for debugging
    ]);

    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    if ($err) {
        return "cURL Error: " . $err;
    } else {
        return  $response;
    }
}


	public function index()
	{
		
	}

    public function screenshot_pending_orders()
    {
        $this->load->view('admin/layout/header');
        $this->load->view('admin/screenshot_pending_orders');
        $this->load->view('admin/layout/footer');
    }
    public function fetch_data() {
      //  $this->load->model('DataModel');
        $from_date = $this->input->post('from_date');
        $to_date = $this->input->post('to_date');
        $page = $this->input->post('page') ?? 1;
        $limit = 10;
        $offset = ($page - 1) * $limit;

        $data = $this->admin_model->get_orders_data($from_date, $to_date, $limit, $offset);
        $total_rows = $this->admin_model->get_orders_count($from_date, $to_date);
        $pagination = ceil($total_rows / $limit);

        echo json_encode(['data' => $data, 'pagination' => $pagination]);
    }
    
     public function view_details() {
      //  $this->load->model('DataModel');
        $id = $this->input->post('id');
        $data['details'] = $this->admin_model->get_details_by_id($id);
      //  echo $this->db->last_query();exit;
        $data['order_items'] = $this->admin_model->get_order_items($id);
       // echo "<pre>";
        //print_r($data);
        //echo json_encode($details);
         $this->load->view('admin/view_order_details',$data);
       
    }
    public function cancel_order($order_id)
    {
        if(!empty($order_id)){
            $data = array(
               
                'order_status' => 'cancel',
                'cancel_date' => date('Y-m-d H:i:s'),
                'updated_on' => date('Y-m-d H:i:s')
                );
                $this->admin_model->common_update('orders',$data,array( 'order_id' => $order_id));
                 $this->session->set_flashdata('one','Order cancelled successfully..!');
			redirect('admin/orders/cancel_orders', 'refresh');
        }
    }

    public function cancelled_orders()
    {
        $this->load->view('admin/layout/header');
        $this->load->view('admin/cancelled_orders');
        $this->load->view('admin/layout/footer'); 
    }

    public function delivered_orders()
    {
        $this->load->view('admin/layout/header');
        $this->load->view('admin/delivered_orders');
        $this->load->view('admin/layout/footer'); 
    }
    public function fetch_delivered_data()
    {
         //  $this->load->model('DataModel');
        $from_date = $this->input->post('from_date');
        $to_date = $this->input->post('to_date');
        $page = $this->input->post('page') ?? 1;
        $limit = 10;
        $offset = ($page - 1) * $limit;

        $data = $this->admin_model->get_delivered_orders_data($from_date, $to_date, $limit, $offset);
       // echo $this->db->last_query();exit;
        $total_rows = $this->admin_model->get_delivered_orders_count($from_date, $to_date);
        $pagination = ceil($total_rows / $limit);

        echo json_encode(['data' => $data, 'pagination' => $pagination]);
    
    }

    public function undelivered_orders()
    {
        $this->load->view('admin/layout/header');
        $this->load->view('admin/undelivered_orders');
        $this->load->view('admin/layout/footer'); 
    }
    public function fetch_undelivered_data()
    {
         //  $this->load->model('DataModel');
        $from_date = $this->input->post('from_date');
        $to_date = $this->input->post('to_date');
        $page = $this->input->post('page') ?? 1;
        $limit = 10;
        $offset = ($page - 1) * $limit;

        $data = $this->admin_model->get_undelivered_orders_data($from_date, $to_date, $limit, $offset);
       // echo $this->db->last_query();exit;
        $total_rows = $this->admin_model->get_undelivered_orders_count($from_date, $to_date);
        $pagination = ceil($total_rows / $limit);

        echo json_encode(['data' => $data, 'pagination' => $pagination]);
    
    }
    
    public function complaint_orders()
    {
        $this->load->view('admin/layout/header');
        $this->load->view('admin/complaint_orders');
        $this->load->view('admin/layout/footer'); 
    }
    public function fetch_complaint_delivered_data()
    {
         //  $this->load->model('DataModel');
        $from_date = $this->input->post('from_date');
        $to_date = $this->input->post('to_date');
        $page = $this->input->post('page') ?? 1;
        $limit = 10;
        $offset = ($page - 1) * $limit;

        $data = $this->admin_model->get_complaint_orders_data($from_date, $to_date, $limit, $offset);
       // echo $this->db->last_query();exit;
        $total_rows = $this->admin_model->get_complaint_orders_count($from_date, $to_date);
        $pagination = ceil($total_rows / $limit);

        echo json_encode(['data' => $data, 'pagination' => $pagination]);
    
    }
    
    public function add_order_complaint_type()
    {
        $order_id = $this->input->post('order_id');
        $complaint_type = $this->input->post('complaint_type');
        $description = $this->input->post('description');
        if($order_id > 0 && !empty($complaint_type)){
            $data = array(
                'complaint_status' => $complaint_type,
                'updated_on' => date('Y-m-d H:i:s')
                );
                $update = $this->admin_model->common_update('orders',$data,array('order_id' => $order_id));
                 $deliveryboy = $this->admin_model->common_fetch('orders',array('order_id' => $order_id));
                 $db = $this->admin_model->common_fetch('users',array('id' => $deliveryboy[0]['delivery_boy_id']));
               //  echo "<pre>";
               //  print_r($db);exit;
                if($complaint_type  == "critical"){
                    $notification_name = "Critical Complaint";
                $notification_content = $description;
                $player_id = $db[0]['player_id'];
                 $this->sendNotification($player_id,$notification_name,$notification_content,2);//exit;

                }else if($complaint_type == "simple"){
                    $notification_name = "User Order Complaint";
                $notification_content = "User complaint for order(".$order_id.").Please don't repeat next time.";
                $player_id = $db[0]['player_id'];
                 $this->sendNotification($player_id,$notification_name,$notification_content,2);//exit;

                }
                
                $data = array(
                'notification_name' => $notification_name,
                'notification_content' => $notification_content,
                'user_type' => 'db',
                'user_id' => $deliveryboy[0]['delivery_boy_id'],
                'created_on' => date('Y-m-d H:i:s')
                 );
                 $insert = $this->admin_model->common_insert('notifications',$data);
            
                
                

                echo json_encode([
                'status' => 'success',
                'message' => 'Complaint Type Updated successfully!'
            ]);
            
        }else{
            echo json_encode([
                'status' => 'error',
                'message' => 'Details Missing!'
            ]);
        }
        
        
        
    }
    
    
    /* cancel orders */
    
    public function cancel_orders()
    {
        $this->load->view('admin/layout/header');
        $this->load->view('admin/cancel_orders');
        $this->load->view('admin/layout/footer'); 
    }
    public function fetch_cancel_delivered_data()
    {
         //  $this->load->model('DataModel');
        $from_date = $this->input->post('from_date');
        $to_date = $this->input->post('to_date');
        $page = $this->input->post('page') ?? 1;
        $limit = 10;
        $offset = ($page - 1) * $limit;

        $data = $this->admin_model->get_cancel_orders_data($from_date, $to_date, $limit, $offset);
       // echo $this->db->last_query();exit;
        $total_rows = $this->admin_model->get_cancel_orders_count($from_date, $to_date);
        $pagination = ceil($total_rows / $limit);

        echo json_encode(['data' => $data, 'pagination' => $pagination]);
    
    }
    
    
    /* cancel orders */
    
   

    


   
	
	


}
