<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Offers extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/userguide3/general/urls.html
	 */

     public function __construct(){ 
        parent::__construct();
        
        $this->load->model('admin/admin_model','admin_model');
        $this->load->library('session');
         date_default_timezone_set("Asia/Kolkata");

		if (!($this->session->userdata('admin_id')))
		{
			//$this->load->view('admin/login');
			redirect('admin/login','refresh');
		}
      }

	public function index()
	{
        //echo 'hi';
		// $this->load->view('admin/layout/header');  
        // $this->load->view('admin/categories');
        // $this->load->view('admin/layout/footer');
	}

    public function view_all_offers()
    {
         $get_offers = $this->admin_model->common_fetch('offers',array());
		// print_r($get_categories);exit;
		 $data['offers'] = $get_offers;
        $this->load->view('admin/layout/header');
        $this->load->view('admin/view_all_offers',$data);
        $this->load->view('admin/layout/footer');
    }

	public function add_new_offer()
	{
		/* Load form validation library */ 
		$this->load->library('form_validation');
		/* Set validation rule for name field in the form */ 
		$this->form_validation->set_rules('offer_name', 'offer_name', 'trim|required');
        $this->form_validation->set_rules('offer_amount', 'offer_amount', 'trim|required|numeric');
        $this->form_validation->set_rules('offer_applied', 'offer_applied', 'required|trim');
        $this->form_validation->set_rules('offfer_start_date', 'offfer_start_date', 'required|trim');
        $this->form_validation->set_rules('offer_end_date', 'offer_end_date', 'required|trim');
		//$this->form_validation->set_rules('user_id', 'user_id', 'required|min_length[6]');
		if ($this->form_validation->run() == FALSE)
	   {
		   $this->session->set_flashdata('two','Please fill all the required details..!');
			redirect('admin/offers/view_all_offers', 'refresh');
	   }else{

             $offer_name = ucfirst($this->input->post('offer_name'));
             $offer_amount = $this->input->post('offer_amount');
             $offer_applied = ucfirst($this->input->post('offer_applied'));
             $offfer_start_date = $this->input->post('offfer_start_date');
             $offer_end_date = $this->input->post('offer_end_date');
			 $get_offers = $this->admin_model->common_fetch('offers',array('offer_name' => $offer_name));
			 if(empty($get_offers))
			 {

			// echo $name;exit;
			//print_r($_FILES['image']);exit;
		  	/*-------------category insert-------------*/
						$data = array(
                                 'offer_name' => $offer_name,
								 'offer_amount' => $offer_amount,
                                 'offer_applied' => $offer_applied,
                                 'offfer_start_date' => $offfer_start_date,
                                 'offer_end_date' => $offer_end_date,
								 'created_on' => date('Y-m-d'),
								 'delete_status' => '1'
						);
						$insert = $this->admin_model->common_insert('offers',$data);
						if($insert)
						{
							$this->session->set_flashdata('one','Offer Created Successfully..!');
							redirect('admin/offers/view_all_offers', 'refresh');
						}else{
							$this->session->set_flashdata('two','Offer not Created Successfully..!');
							redirect('admin/offers/view_all_offers', 'refresh');
						}
					
                    
				

		}else{
			$this->session->set_flashdata('two','Offer Name Already Created..!');
			redirect('admin/offers/view_all_offers', 'refresh');
		}

	   }


		
	}


	public function edit_offer($id)
	{
		$get_offers = $this->admin_model->common_fetch('offers',array('id' => $id));
		// print_r($get_categories);exit;
		 $data['offers'] = $get_offers;
        $this->load->view('admin/layout/header');
        $this->load->view('admin/edit_offer',$data);
        $this->load->view('admin/layout/footer');
	}

	public function update_offer_details($id)
	{
		/*updating offre details-------*/
		
             $offer_name = ucfirst($this->input->post('offer_name'));
             $offer_amount = $this->input->post('offer_amount');
             $offer_applied = ucfirst($this->input->post('offer_applied'));
             $offfer_start_date = $this->input->post('offfer_start_date');
             $offer_end_date = $this->input->post('offer_end_date');
		$get_offers = $this->admin_model->common_fetch('offers',array('id' => $id));
			 
		// echo $name;exit;
		//print_r($_FILES['image']);exit;
				if(!empty($get_offers))
				{
					//$unlink_amenity = unlink($get_categories['0']['image']);
					$data = array(
						         'offer_name' => $offer_name,
								 'offer_amount' => $offer_amount,
                                 'offer_applied' => $offer_applied,
                                 'offfer_start_date' => $offfer_start_date,
                                 'offer_end_date' => $offer_end_date,
								 'updated_on' => date('Y-m-d')
			            );
			   $insert = $this->admin_model->common_update('offers',$data,array('id' => $id));
               if($insert)
               {
                $this->session->set_flashdata('one','Offer Details Updated Successfully..!');
                redirect('admin/offers/view_all_offers/', 'refresh');
               }else{
                $this->session->set_flashdata('two','Offer Details Not Updated Successfully..!');
                redirect('admin/offers/edit_offer/'.$id.'', 'refresh');
               }
				}else{
                    $this->session->set_flashdata('two','Offer Details Not Updated Successfully..!');
                    redirect('admin/offers/edit_offer/'.$id.'', 'refresh');
                }
	   /*----------imageupload-----------------*/
			  


			
			// else{
			// 			$this->session->set_flashdata('two','Please Upload Category Image..!');
			// 			redirect('admin/categories/edit_category/'.$id.'', 'refresh');
			// }
		/*------updating category details---*/
	}


	public function update_offer()
	{
		$id = $this->input->post('id');
	    $status = $this->input->post('status');
	    
	    if($status == '1')
	    {
	        $status = '0';
	    }else{
	       $status = '1'; 
	    }
	    
	       $data = array(
	            'delete_status' => $status,
	            'updated_on' => date('Y-m-d')
	            );
	            
	           // echo $amenity.$id;exit;
	            $update_offer = $this->admin_model->common_update('offers',$data,array('id' => $id));
	            
	    echo json_encode($update_offer);
		//echo $this->db->last_query();
				exit;
	}

	public function delete_offer($id)
	{
	    $get_offer = $this->admin_model->common_fetch('offers',array('id' => $id));
	    
	    $delete = $this->db->delete('offers',array('id'=>$id));
	    // $unlink_category = unlink($get_offer['0']['category_image']);
	     if($delete)
	     {
	         $this->session->set_flashdata('one','Offer Details Deleted Successfully..!');
                  redirect('admin/offers/view_all_offers', 'refresh');
	     }else{
	         $this->session->set_flashdata('two','Offer Details Not Deleted..!');
                  redirect('admin/offers/view_all_offers/', 'refresh');
	     }
	}

    


   
	
	


}
