<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Locations extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/userguide3/general/urls.html
	 */

     public function __construct(){
        parent::__construct();
        
        $this->load->model('admin/admin_model','admin_model');
        $this->load->library('session');
date_default_timezone_set("Asia/Kolkata");

        if (!($this->session->userdata('admin_id')))
        {
            //$this->load->view('admin/login');
            redirect('admin/login','refresh');
        }
      }

	public function index()
	{
		
	}

    public function locations_list()
    {
        $this->load->view('admin/layout/header');
        $this->load->view('admin/list_locations');
        $this->load->view('admin/layout/footer');
    }
    public function fetch_data() {
      //  $this->load->model('DataModel');
      //  $from_date = $this->input->post('from_date');
      //  $to_date = $this->input->post('to_date');
      $from_date = "";
      $to_date = "";
        $page = $this->input->post('page') ?? 1;
        $limit = 5;
        $offset = ($page - 1) * $limit;

        $data = $this->admin_model->get_data($from_date, $to_date, $limit, $offset);
        $total_rows = $this->admin_model->get_count($from_date, $to_date);
        $pagination = ceil($total_rows / $limit);

        echo json_encode(['data' => $data, 'pagination' => $pagination]);
    }
    
    public function add_location()
    {
         $this->load->view('admin/layout/header');
        $this->load->view('admin/add_location');
        $this->load->view('admin/layout/footer'); 
    
    }
    public function insert_new_location()
    {
        $name=  $this->input->post('name');
         $latitude =  $this->input->post('latitude');
        $longitude =  $this->input->post('longitude');
         $radius =  $this->input->post('radius');
         if(!empty($name) && !empty($latitude) && !empty($longitude) && !empty($radius)){
             $check = $this->admin_model->common_fetch('locations',array('name'=> $name));
             if(empty($check)){
                $data = array(
                                        'name' => $name,
                                         'latitude' => $latitude,
                                          'longitude' => $longitude,
                                        'radius' => $radius,
                                        'updated_on' => date('Y-m-d H:i:s')
                                );
                                            $this->admin_model->common_insert('locations',$data);
                                     $this->session->set_flashdata('one','Location added successfully..!');
			redirect('admin/locations/locations_list', 'refresh');
      
          
             }else{
                  $this->session->set_flashdata('two','Location name already exist..!');
			redirect('admin/locations/add_location', 'refresh');
       
             }
              
             
         }else{
              $this->session->set_flashdata('two','Please fill all the fields..!');
			redirect('admin/locations/add_location', 'refresh');
       
         }
       
    }
    
    public function edit_location($id)
    {
          $data['location'] = $this->admin_model->common_fetch('locations',array('id'=> $id));
           
         $this->load->view('admin/layout/header');
        $this->load->view('admin/edit_location',$data);
        $this->load->view('admin/layout/footer');
    }
    public function update_location_details()
    {
        $id =  $this->input->post('id');
        $name =  $this->input->post('name');
         $latitude =  $this->input->post('latitude');
        $longitude =  $this->input->post('longitude');
         $radius =  $this->input->post('radius');
         if($id > 0 && !empty($name) && !empty($latitude) && !empty($longitude) && !empty($radius)){
                $data = array(
                                        'name' => $name,
                                         'latitude' => $latitude,
                                          'longitude' => $longitude,
                                        'radius' => $radius,
                                        'updated_on' => date('Y-m-d H:i:s')
                                );
                                            $this->admin_model->common_update('locations',$data,array('id' => $id));
                                     $this->session->set_flashdata('one','Location Updated successfully..!');
			redirect('admin/locations/locations_list', 'refresh');
             
         }else{
              $this->session->set_flashdata('two','Please fill all the fields..!');
			redirect('admin/locations/edit_location/'.$id, 'refresh');
       
         }

    }
    public function delete_location($id)
    {
         $data = array(
                                        'delete_status' => 0,
                                        'updated_on' => date('Y-m-d H:i:s')
                                );
                                            $this->admin_model->common_update('locations',$data,array('id'=> $id));
                                            $this->session->set_flashdata('one','Location deleted successfully..!');
			redirect('admin/locations/locations_list/', 'refresh');
       
         
    }



    public function update_status_of_ordering()
    {
       $status =  $this->input->post('status');
       if(!empty($status)){
            $data = array(
                                        'status' => $status,
                                        'updated_on' => date('Y-m-d H:i:s')
                                );
                                            $this->admin_model->common_update('enable_disable',$data,array('id'=> 1));
         $this->session->set_flashdata('one','Status updated successfully..!');
			redirect('admin/services/disabling_enabling', 'refresh');
      
       
       }else{
           $this->session->set_flashdata('two','Status not updated..!');
			redirect('admin/services/disabling_enabling', 'refresh');
       }
                 
    }
    public function update_location_status()
    {
		$id = $this->input->post('id');
	    $status = $this->input->post('status');
	    
	    if($status == '1')
	    {
	        $status = '0';
	    }else{
	       $status = '1'; 
	    }
	    
	       $data = array(
	            'status' => $status,
	            'updated_on' => date('Y-m-d H:i:s')
	            );
	            
	           // echo $amenity.$id;exit;
	            $update_category = $this->admin_model->common_update('locations',$data,array('id' => $id));
	            
	            echo json_encode([
                'status' => 'success',
                'message' => 'Location status chnagedsuccessfully!'
            ]);
	            
	   // echo json_encode($update_category);
		//echo $this->db->last_query();
		//		exit;
	}


    


   
	
	


}
