<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Delivery_Boys extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/userguide3/general/urls.html
	 */

     public function __construct(){
        parent::__construct();
        
        $this->load->model('admin/admin_model','admin_model');
        $this->load->library('session');
date_default_timezone_set("Asia/Kolkata");
		if (!($this->session->userdata('admin_id')))
		{
			//$this->load->view('admin/login');
			redirect('admin/login','refresh');
		}
      }

	public function index()
	{
		
	}

    public function view_all_delivery_boys()
    {
        $this->load->view('admin/layout/header');
        $this->load->view('admin/view_all_delivery_boys');
        $this->load->view('admin/layout/footer');
    }
    public function fetch_deliveryboys_data()
    {
         //  $this->load->model('DataModel');
        $user_name = $this->input->post('user_name');
       // $to_date = $this->input->post('to_date');
        $page = $this->input->post('page') ?? 1;
        $limit = 10;
        $offset = ($page - 1) * $limit;

        $data = $this->admin_model->get_db_data($user_name, $limit, $offset);
       // echo $this->db->last_query();exit;
        $total_rows = $this->admin_model->get_db_count($user_name);
        $pagination = ceil($total_rows / $limit);

        echo json_encode(['data' => $data, 'pagination' => $pagination]);
    
    }
    public function delivery_boy_joinings()
    {
        $data['clubs'] = $this->admin_model->common_fetch('clubs',array('delete_status' => 1));
        $this->load->view('admin/layout/header');
        $this->load->view('admin/db_clubs_joined',$data);
        $this->load->view('admin/layout/footer');
    }
    
    public function fetch_deliveryboys_club_data()
    {
          //  $this->load->model('DataModel');
        $club = $this->input->post('club');
       // $to_date = $this->input->post('to_date');
        $page = $this->input->post('page') ?? 1;
        $limit = 10;
        $offset = ($page - 1) * $limit;

        $data = $this->admin_model->get_db_clubs_data($club, $limit, $offset);
       // echo $this->db->last_query();exit;
        $total_rows = $this->admin_model->get_db_clubs_count($club);
        $pagination = ceil($total_rows / $limit);

        echo json_encode(['data' => $data, 'pagination' => $pagination, 'count' => $total_rows]);
    }

    public function delivery_boy_refund_request()
    {
        $this->load->view('admin/layout/header');
        $this->load->view('admin/delivery_boy_refund_request');
        $this->load->view('admin/layout/footer'); 
    }
    public function fetch_deliveryboys_club_withdraws()
    {
          //  $this->load->model('DataModel');
        $user_name = $this->input->post('user_name');
       // $to_date = $this->input->post('to_date');
        $page = $this->input->post('page') ?? 1;
        $limit = 10;
        $offset = ($page - 1) * $limit;

        $data = $this->admin_model->get_db_club_withdraw_data($user_name, $limit, $offset);
       // echo $this->db->last_query();exit;
        $total_rows = $this->admin_model->get_db_club_withdraw_count($user_name);
        $pagination = ceil($total_rows / $limit);

        echo json_encode(['data' => $data, 'pagination' => $pagination]);
    
    }
    public function settle_db_advance_amount()
    {
        $id = $this->input->post('id');
        $get = $this->admin_model->common_fetch('db_joined_withdrawn_clubs',array('id' => $id));
        if($id > 0 && !empty($get)){
          $get_club = $this->admin_model->common_fetch('clubs',array('id' => $get[0]['club_id']));
          $data = array(
              'refunded_amount' => $get_club[0]['advance_amount'],
              'refunded_date' => date('Y-m-d H:i:s'),
              'status' => 'refunded',
              'updated_on' => date('Y-m-d H:i:s')
              );
              $this->admin_model->common_update('db_joined_withdrawn_clubs',$data,array('id' => $id));
              echo json_encode([
                'status' => 'success',
                'message' => 'Settlement successfully completed..!'
            ]);
          
        }else{
              echo json_encode([
                'status' => 'error',
                'message' => 'Settlement not completed.'
            ]);
        }
       
    }

	public function delivery_boy_refunds()
    {
        $this->load->view('admin/layout/header');
        $this->load->view('admin/delivery_boy_refunds');
        $this->load->view('admin/layout/footer'); 
    }
    
    public function fetch_deliveryboys_refunds()
    {
          //  $this->load->model('DataModel');
        $user_name = $this->input->post('user_name');
       // $to_date = $this->input->post('to_date');
        $page = $this->input->post('page') ?? 1;
        $limit = 10;
        $offset = ($page - 1) * $limit;

        $data = $this->admin_model->get_db_refund_data($user_name, $limit, $offset);
       // echo $this->db->last_query();exit;
        $total_rows = $this->admin_model->get_db_refund_count($user_name);
        $pagination = ceil($total_rows / $limit);

        echo json_encode(['data' => $data, 'pagination' => $pagination]);
    
    }

    


   
	
	


}
