<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Clubs extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/userguide3/general/urls.html
	 */

     public function __construct(){ 
        parent::__construct();
        
        $this->load->model('admin/admin_model','admin_model');
        $this->load->library('session');
        date_default_timezone_set("Asia/Kolkata");
		if (!($this->session->userdata('admin_id')))
		{
			//$this->load->view('admin/login');
			redirect('admin/login','refresh');
		}
      }

	public function index()
	{
        //echo 'hi';
		// $this->load->view('admin/layout/header');  
        // $this->load->view('admin/categories');
        // $this->load->view('admin/layout/footer');
	}

    public function view_all_clubs()
    {
         $get_clubs = $this->admin_model->common_fetch('clubs',array());
		// print_r($get_categories);exit;
		 $data['clubs'] = $get_clubs;
        $this->load->view('admin/layout/header');
        $this->load->view('admin/view_all_clubs',$data);
        $this->load->view('admin/layout/footer');
    }

    public function add_new_club()
    {
        $this->load->view('admin/layout/header');
        $this->load->view('admin/add_new_club');
        $this->load->view('admin/layout/footer');
    }

	public function insert_new_club()
	{
		/* Load form validation library */ 
		$this->load->library('form_validation');
		/* Set validation rule for name field in the form */ 
		$this->form_validation->set_rules('club_name', 'club_name', 'trim|required');
        $this->form_validation->set_rules('Joining_amount', 'Joining_amount', 'trim|required|numeric');
        $this->form_validation->set_rules('advance_amount', 'advance_amount', 'required|trim|numeric');
        $this->form_validation->set_rules('benifit', 'benifit', 'required|trim');
        $this->form_validation->set_rules('disclaimer', 'disclaimer', 'required|trim');
		//$this->form_validation->set_rules('user_id', 'user_id', 'required|min_length[6]');
		if ($this->form_validation->run() == FALSE)
	   {
		   $this->session->set_flashdata('two','Please fill all the required details..!');
			redirect('admin/clubs/add_new_club', 'refresh');
	   }else{

             $club_name = ucfirst($this->input->post('club_name'));
             $Joining_amount = $this->input->post('Joining_amount');
             $advance_amount = $this->input->post('advance_amount');
             $benifit = ucfirst($this->input->post('benifit'));
             $disclaimer = ucfirst($this->input->post('disclaimer'));
             $total_amount = $Joining_amount + $advance_amount;
			 $get_clubs = $this->admin_model->common_fetch('clubs',array('club_name ' => $club_name));
			 if(empty($get_clubs))
			 {

			// echo $name;exit;
			//print_r($_FILES['image']);exit;
		  	/*-------------category insert-------------*/
						$data = array(
                                 'club_name' => $club_name,
								 'Joining_amount' => $Joining_amount,
                                 'advance_amount' => $advance_amount,
                                 'total_amount' => $total_amount,
                                 'benifit' => $benifit,
                                 'disclaimer' => $disclaimer,
								 'created_on' => date('Y-m-d'),
								 'delete_status' => '1'
						);
						$insert = $this->admin_model->common_insert('clubs',$data);
						if($insert)
						{
							$this->session->set_flashdata('one','Club Created Successfully..!');
							redirect('admin/clubs/view_all_clubs', 'refresh');
						}else{
							$this->session->set_flashdata('two','Club not Created Successfully..!');
							redirect('admin/clubs/add_new_club', 'refresh');
						}
					
                    
				

		}else{
			$this->session->set_flashdata('two','Club Name Already Created..!');
			redirect('admin/clubs/add_new_club', 'refresh');
		}

	   }


		
	}


	public function edit_club($id)
	{
		$get_clubs = $this->admin_model->common_fetch('clubs',array('id' => $id));
		// print_r($get_categories);exit;
		 $data['clubs'] = $get_clubs;
        $this->load->view('admin/layout/header');
        $this->load->view('admin/edit_club',$data);
        $this->load->view('admin/layout/footer');
	}

	public function update_club_details($id)
	{
		/*updating offre details-------*/
		
        $club_name = ucfirst($this->input->post('club_name'));
        $Joining_amount = $this->input->post('Joining_amount');
        $advance_amount = $this->input->post('advance_amount');
        $benifit = ucfirst($this->input->post('benifit'));
        $disclaimer = ucfirst($this->input->post('disclaimer'));
        $total_amount = $Joining_amount + $advance_amount;

		$get_clubs = $this->admin_model->common_fetch('clubs',array('id' => $id));
			 
		// echo $name;exit;
		//print_r($_FILES['image']);exit;
				if(count($get_clubs) == '1')
				{
					//$unlink_amenity = unlink($get_categories['0']['image']);
					$data = array(
                                'club_name' => $club_name,
                                'Joining_amount' => $Joining_amount,
                                'advance_amount' => $advance_amount,
                                'total_amount' => $total_amount,
                                'benifit' => $benifit,
                                'disclaimer' => $disclaimer,
								'updated_on' => date('Y-m-d')
			            );
                    $update = $this->admin_model->common_update('clubs',$data,array('id' => $id));
                    if($update)
                    {
                        $this->session->set_flashdata('one','Club Details Updated Successfully..!');
                        redirect('admin/clubs/view_all_clubs/', 'refresh');
                    }else{
                        $this->session->set_flashdata('two','Offer Details Not Updated Successfully..!');
                        redirect('admin/clubs/edit_club/'.$id.'', 'refresh');
                    }
				}else{
                    $this->session->set_flashdata('two','Offer Details Not Updated Successfully..!');
                    redirect('admin/clubs/edit_club/'.$id.'', 'refresh');
                }
	   /*----------imageupload-----------------*/
			  


			
			// else{
			// 			$this->session->set_flashdata('two','Please Upload Category Image..!');
			// 			redirect('admin/categories/edit_category/'.$id.'', 'refresh');
			// }
		/*------updating category details---*/
	}


	public function update_club()
	{
		$id = $this->input->post('id');
	    $status = $this->input->post('status');
	    
	    if($status == '1')
	    {
	        $status = '0';
	    }else{
	       $status = '1'; 
	    }
	    
	       $data = array(
	            'delete_status' => $status,
	            'updated_on' => date('Y-m-d')
	            );
	            
	           // echo $amenity.$id;exit;
	            $update_club = $this->admin_model->common_update('clubs',$data,array('id' => $id));
	            
	    echo json_encode($update_club);
		//echo $this->db->last_query();
				exit;
	}

	public function delete_club($id)
	{
	    $get_club = $this->admin_model->common_fetch('clubs',array('id' => $id));
	    
	    $delete = $this->db->delete('clubs',array('id'=>$id));
	    // $unlink_category = unlink($get_offer['0']['category_image']);
	     if($delete)
	     {
	         $this->session->set_flashdata('one','Club Details Deleted Successfully..!');
                  redirect('admin/clubs/view_all_clubs', 'refresh');
	     }else{
	         $this->session->set_flashdata('two','Club Details Not Deleted..!');
                  redirect('admin/clubs/view_all_clubs/', 'refresh');
	     }
	}




    /*----------------price creation------------*/

    public function view_all_prices()
    {
         $get_prices = $this->admin_model->prices_fetch();
        
		// print_r($get_categories);exit;
		 $data['prices'] = $get_prices;
         
        $this->load->view('admin/layout/header');
        $this->load->view('admin/view_all_prices',$data);
        $this->load->view('admin/layout/footer');
    }

    public function add_new_price()
    {
        $get_clubs = $this->admin_model->common_fetch('clubs',array());
        $data['clubs'] = $get_clubs;
        $this->load->view('admin/layout/header');
        $this->load->view('admin/add_new_price',$data);
        $this->load->view('admin/layout/footer');
    }

	public function insert_new_price()
	{
		/* Load form validation library */ 
		$this->load->library('form_validation');
		/* Set validation rule for name field in the form */ 
		$this->form_validation->set_rules('club_id', 'club_id', 'trim|required');
        $this->form_validation->set_rules('price_range_from', 'price_range_from', 'trim|required|numeric');
        $this->form_validation->set_rules('price_range_to', 'price_range_to', 'required|trim|numeric');
        $this->form_validation->set_rules('delivery_charges', 'delivery_charges', 'required|trim|numeric');
        $this->form_validation->set_rules('maintenance_fee', 'maintenance_fee', 'required|trim|numeric');
		//$this->form_validation->set_rules('user_id', 'user_id', 'required|min_length[6]');
		if ($this->form_validation->run() == FALSE)
	   {
		   $this->session->set_flashdata('two','Please fill all the required details..!');
			redirect('admin/clubs/add_new_price', 'refresh');
	   }else{

        $club_id = $this->input->post('club_id');
        $price_range_from = $this->input->post('price_range_from');
        $price_range_to = $this->input->post('price_range_to');
        $delivery_charges = $this->input->post('delivery_charges');
        $maintenance_fee = $this->input->post('maintenance_fee');
        if($price_range_from >= $price_range_to){
            $this->session->set_flashdata('two','Price Range from need to be < price range to..!');
							redirect('admin/clubs/add_new_price', 'refresh');
        }else{
            
        
        
			 $get_clubs = $this->admin_model->common_fetch('prices',array('club_id ' => $club_id));
			 if(empty($get_clubs))
			 {

			// echo $name;exit;
			//print_r($_FILES['image']);exit;
		  	/*-------------category insert-------------*/
						$data = array(
                                 'club_id' => $club_id,
								 'price_range_from' => $price_range_from,
                                 'price_range_to' => $price_range_to,
                                 'delivery_charges' => $delivery_charges,
                                 'maintenance_fee' => $maintenance_fee,
								 'created_on' => date('Y-m-d'),
								 'delete_status' => '1'
						);
						$insert = $this->admin_model->common_insert('prices',$data);
						if($insert)
						{
							$this->session->set_flashdata('one','Price Created Successfully..!');
							redirect('admin/clubs/view_all_prices', 'refresh');
						}else{
							$this->session->set_flashdata('two','Price not Created Successfully..!');
							redirect('admin/clubs/add_new_price', 'refresh');
						}
					
                    
				

		}else{
			$this->session->set_flashdata('two','Club Name Already Created..!');
			redirect('admin/clubs/add_new_club', 'refresh');
		}
        }

	   }


		
	}


	public function edit_price($id)
	{
		$get_prices = $this->admin_model->common_fetch('prices',array('id' => $id));
		// print_r($get_categories);exit;
		 $data['prices'] = $get_prices;
         $get_clubs = $this->admin_model->common_fetch('clubs',array());
        $data['clubs'] = $get_clubs;
        $this->load->view('admin/layout/header');
        $this->load->view('admin/edit_price',$data);
        $this->load->view('admin/layout/footer');
	}

	public function update_price_details($id)
	{
		/*updating offre details-------*/
		
        $club_id = $this->input->post('club_id');
        $price_range_from = $this->input->post('price_range_from');
        $price_range_to = $this->input->post('price_range_to');
        $delivery_charges = $this->input->post('delivery_charges');
        $maintenance_fee = $this->input->post('maintenance_fee');
        //$total_amount = $Joining_amount + $advance_amount;

		$get_prices = $this->admin_model->common_fetch('prices',array('id' => $id));
			 
		// echo $name;exit;
		//print_r($_FILES['image']);exit;
				if(count($get_prices) == 1)
				{
					//$unlink_amenity = unlink($get_categories['0']['image']);
					$data = array(
                                'club_id' => $club_id,
                                'price_range_from' => $price_range_from,
                                'price_range_to' => $price_range_to,
                                'delivery_charges' => $delivery_charges,
                                'maintenance_fee' => $maintenance_fee,
								'updated_on' => date('Y-m-d')
			            );
			   $update = $this->admin_model->common_update('prices',$data,array('id' => $id));
               if($update)
               {
                $this->session->set_flashdata('one','Price Details Updated Successfully..!');
                redirect('admin/clubs/view_all_prices/', 'refresh');
               }else{
                $this->session->set_flashdata('two','Price Details Not Updated Successfully..!');
                redirect('admin/clubs/edit_price/'.$id.'', 'refresh');
               }
				}else{
                    $this->session->set_flashdata('two','Price Details Not Updated Successfully..!');
                    redirect('admin/clubs/edit_price/'.$id.'', 'refresh');
                }
	   /*----------imageupload-----------------*/
			  


			
			// else{
			// 			$this->session->set_flashdata('two','Please Upload Category Image..!');
			// 			redirect('admin/categories/edit_category/'.$id.'', 'refresh');
			// }
		/*------updating category details---*/
	}


	public function update_price()
	{
		$id = $this->input->post('id');
	    $status = $this->input->post('status');
	    
	    if($status == '1')
	    {
	        $status = '0';
	    }else{
	       $status = '1'; 
	    }
	    
	       $data = array(
	            'delete_status' => $status,
	            'updated_on' => date('Y-m-d')
	            );
	            
	           // echo $amenity.$id;exit;
	            $update_club = $this->admin_model->common_update('prices',$data,array('id' => $id));
	            
	    echo json_encode($update_club);
		//echo $this->db->last_query();
				exit;
	}

	public function delete_price($id)
	{
	    $get_club = $this->admin_model->common_fetch('prices',array('id' => $id));
	    
	    $delete = $this->db->delete('prices',array('id'=>$id));
	    // $unlink_category = unlink($get_offer['0']['category_image']);
	     if($delete)
	     {
	         $this->session->set_flashdata('one','Price Details Deleted Successfully..!');
                  redirect('admin/clubs/view_all_prices', 'refresh');
	     }else{
	         $this->session->set_flashdata('two','Price Details Not Deleted..!');
                  redirect('admin/clubs/view_all_prices/', 'refresh');
	     }
	}

    /*------------------price creation-------------------------*/

    


   
	
	


}
