<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Api_model extends CI_Model {

/*Commom Fetch*/
function common_fetch($table,$where){
	$this->db->select()->from($table);
	$this->db->where($where);
    $this->db->order_by('id','desc');
	$query= $this->db->get();
    return $query->result_array();
	 
}
/*Commom Fetch*/

/*common insert*/
function common_insert($table,$data)
{
    $this->db->insert($table,$data);
    $id = $this->db->insert_id();
    return $id;
} 
/*common insert */

/*common update */
function common_update($table,$data,$where)
{
    $this->db->where($where);
    $this->db->update($table,$data);
    $id = $this->db->insert_id();
   return $id;
   // return $this->db->last_query();
}
/*common update */

function products_fetch($cat_id)
{
    $this->db->select('products.*,products.id as product_id,units.unit_name');
    $this->db->from('products');
    $this->db->join('units','units.id = products.unit_id','left');
    $this->db->where('products.cat_id',$cat_id);
    $this->db->where('products.delete_status','1');
    $query = $this->db->get();
    //$this->db->order_by('products.id','desc');
    return $query->result_array();
}


function fetch_single_product($product_id)
{
  $this->db->select('products.*,units.unit_name,categories.category_name');
  $this->db->from('products');
  $this->db->join('categories','categories.id = products.cat_id','left');
  $this->db->join('units','units.id = products.unit_id','left');
  $this->db->where('products.id',$product_id);
  $this->db->where('products.delete_status','1');
  $query = $this->db->get();
  return $query->result_array();
}

function get_cart_items($user_id)
{
    $this->db->select('cart.*,cart.quantity as cart_quantity,products.*,units.unit_name');
    $this->db->from('cart');
    $this->db->join('products','products.id = cart.product_id','left');
    $this->db->join('units','units.id = products.unit_id','left');
    $this->db->where('cart.user_id',$user_id);
    $this->db->where('products.delete_status','1');
    $query = $this->db->get();
    return $query->result_array();
    
}

function fetch_wishlist_items($user_id)
{
    $this->db->select('user_wishlist.*,products.*,units.unit_name');
    $this->db->from('user_wishlist');
    $this->db->join('products','products.id = user_wishlist.product_id','left');
    $this->db->join('units','units.id = products.unit_id','left');
    $this->db->where('user_wishlist.user_id',$user_id);
    $query = $this->db->get();
    return $query->result_array();
}


function get_distance($data)
{
    $this->db->select("COALESCE(( 6371 * acos( cos( radians({$data['latitude']}) ) * cos( radians( `latitude` ) ) * cos( radians( longitude ) - radians({$data['longitude']}) ) + sin( radians({$data['latitude']}) ) * sin( radians( `latitude` ) ) ) ), 0) AS distance, users.*", False);
    $this->db->from('users');
    $this->db->where('user_type','2');
    $this->db->order_by('distance','asc');
    //$this->db->where('distance <=',$distannce);
    $query = $this->db->get();
    return $query->result_array();
}

/*get single order details*/
public function get_order_details($order_id)
{
    $this->db->select('or.*,us.user_name as delivery_boy_name,us.user_mobile as delivery_boy_mobile');
    $this->db->from('orders or');
    $this->db->join('users us','us.id = or.delivery_boy_id','left');
    $this->db->where('or.order_id',$order_id);
    $query = $this->db->get();
    return $query->result_array();

}

public function get_order_items($order_id)
{
    $this->db->select('oi.*,pr.product_name ,pr.product_image , un.unit_name');
    $this->db->from('order_items oi');
    $this->db->join('products pr','pr.id = oi.product_id','left');
    $this->db->join('units un','un.id = pr.unit_id','left');
    $this->db->where('oi.order_id',$order_id);
    $query = $this->db->get();
    return $query->result_array();
}

public function get_order_status($order_id)
{
    $this->db->select('orders.order_status');
    $this->db->from('orders');
    $this->db->where('order_id',$order_id);
    $query = $this->db->get();
    return $query->result_array();

}
/*get single order details*/


}
?>