<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
class Api extends REST_Controller {
	
	protected $client_request = NULL;
	
	function __construct()
	{
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		error_reporting(0);
		set_time_limit(0);
		$this->load->model('apis/api_model','user_model');
		//$this->load->library('Notifications');
		$this->load->library('form_validation');
		
		$this->client_request = new stdClass();
		$this->client_request = json_decode(file_get_contents('php://input', true));
		$this->client_request = json_decode(json_encode($this->client_request), true);
	}

/*REFERANCE CODE*/
	function referance_post(){
		$response = array('status' => false, 'message' => '', 'response' => array());
		$user_input = $this->client_request;
		extract($user_input);
		if(!$id)
		{
			$response = array('status' => false, 'message' => 'Enter Email ID!', 'response' => array());
			$this->response($response);
		}
		
		
		$this->response($response);
	}
/*REFERANCE CODE*/

/*user login module*/
    public function user_login_post()
    {
        $user_input = $this->client_request;
        extract($user_input);
        if(empty($user_mobile)){
            $response = array('status' => false, 'message' => 'Enter Mobile number', 'response' => (object)array());
            $this->response($response);
        }elseif(empty($otp_status)){
            $response = array('status' => false, 'message' => 'Enter Otp status', 'response' => (object)array());
            $this->response($response);
        }else{  
            if($otp_status=='not_verify'){
                //echo $this->db->last_query();exit;
                
                $check_mobile = $this->user_model->common_fetch('users',array('user_mobile'  => $user_mobile));
                if(!empty($check_mobile))
                {
                $get_otp = rand(1000,9999);
                // $send = $this->user_model->smssend($user_mobile,$get_otp);
                //echo $end;exit;
                $response = array('status' => true, 'message' => 'Otp generated successfully', 'response' => array('user_mobile' => $user_mobile, 'otp' => $get_otp));
                $this->response($response);  
                }else{
                $response = array('status' => false, 'message' => 'Mobile number is not registered', 'response' => (object)array());
                $this->response($response);
                    }
            
            
                }else if($otp_status == 'verify'){
                    if(empty($token)){
                    
                        $response = array('status' => false, 'message' => 'Token is empty', 'response' => (object)array());
                        $this->response($response);
                        
                    }else{
                        $check_mobile = $this->user_model->common_fetch('users',array('user_mobile'  => $user_mobile));
                        if(!empty($check_mobile)){
                            $data = array(
                                'token'  => $token,
                                'updated_on' => date('Y-m-d')
                            );
                            if($check_mobile[0]['delete_status']=='1'){
                                $update_token = $this->user_model->common_update('users',$data,array('id' => $check_mobile['0']['id']));
                                $token = $this->user_model->common_fetch('users',array('user_mobile'  => $user_mobile));
                                $response = array('status' => true, 'message' => 'user logged in successfully', 'response' => $token[0]);
                                $this->response($response); 
                            }else{
                                $update_token = $this->user_model->common_update('users',$data,array('id' => $check_mobile['0']['id']));
                                $response = array('status' => false, 'message' => 'user status is inactive', 'response' => (object)(array()));
                                $this->response($response);
                            }
                        }
                    }
                }else{
                    $response = array('status' => false, 'message' => 'otp status is wrong', 'response' => array());
                    $this->response($response);
                }
        }
    }
/*user login module*/

/*resend OTP*/

        public function resend_otp_post()
        {
                $user_input = $this->client_request;
                extract($user_input);
            
            if(empty($user_mobile))
            {
                $response = array('status' => false, 'message' => 'mobile number is empty', 'response' => (object)array());
                $this->response($response);
                
            }else{
                
                    $get_otp = rand(1000,9999);
                    //$send = $this->user_model->smssend($user_mobile,$get_otp);
                        $response = array('status' => true, 'message' => 'Resend Otp generated successfully', 'response' => array('user_mobile' => $user_mobile, 'otp' => $get_otp));
                        $this->response($response); 
                
            }
        }


/*resend OTP*/

/*sign up user*/
public function user_registration_post()
  {
    $email = '';
    $user_input = $this->client_request;
    extract($user_input);
    if(empty($user_mobile)){
        $response = array('status' => false, 'message' => 'Enter Mobile number', 'response' => (object)array());
		$this->response($response);
    }else if(empty($user_name)){
        $response = array('status' => false, 'message' => 'Enter Your Name', 'response' => (object)array());
		$this->response($response);
    }else if(empty($user_age)){
        $response = array('status' => false, 'message' => 'Enter Your Age', 'response' => (object)array());
		$this->response($response);
    }else if(empty($user_gender)){
        $response = array('status' => false, 'message' => 'Enter Your Gender', 'response' => (object)array());
		$this->response($response);
    }else if(empty($otp_status)){
        $response = array('status' => false, 'message' => 'OTP status is empty', 'response' => (object)array());
		$this->response($response);
    }else{
        
        if(!empty($user_mobile) && !empty($user_name) && !empty($user_age) && !empty($user_gender) && !empty($otp_status))
        {
            if($otp_status == 'not_verify')
            {
                $check_mobile = $this->user_model->common_fetch('users',array('user_mobile'  => $user_mobile));
                    // print_r($check_mobile);exit;
                if(empty($check_mobile))
                {
                    // print_r($check_mobile);exit;
                    $get_otp = rand(1000,9999);
                //$send = $this->user_model->smssend($mobile_number,$get_otp);
                //echo $end;exit;
                    $response = array('status' => true, 'message' => 'Otp generated successfully', 'response' => array('user_mobile' => $user_mobile, 'otp' => $get_otp));
                    $this->response($response);  
                }else{
                    $response = array('status' => false, 'message' => 'user already register with this mobile number', 'response' => (object)array());
                        $this->response($response);
                }

            }else if($otp_status == 'verify'){
                
                $data = array(
                'user_name' => $user_name,
                'user_mobile' => $user_mobile,
                'user_age' => $user_age,
                'user_gender' => $user_gender,
                'delete_status' => '1',
                'created_on' => date('Y-m-d')
                );
                $insert_user_details = $this->user_model->common_insert('users',$data);
                $get_detials = $this->user_model->common_fetch('users',array('id' => $insert_user_details));
                if(!empty($get_detials))
                {
                    //  $get_otp = rand(1000,9999);
                    //  $send = $this->user_model->smssend($mobile_number,$get_otp);
                    //  $get_detials[0]['otp'] = $get_otp;
                    //  // print_r($get_detials);exit;
                    $response = array('status' => true, 'message' => 'User Details Stored in DB successfully', 'response' => $get_detials[0]);
                    $this->response($response);
                }else{
                    $response = array('status' => false, 'message' => 'user not created', 'response' => array());
                    $this->response($response);
                }
            }else{
                $response = array('status' => false, 'message' => 'otp status is wrong', 'response' => array());
                    $this->response($response);
            }
            
       
           
            
        }else{
            $response = array('status' => false, 'message' => 'Please Enter Required Fields', 'response' => (object)array());
		$this->response($response);
        }
    }
  }
/*sign up user*/

/*user location update*/

public function user_location_update_post()
{
    $user_input = $this->client_request;
    extract($user_input);
    if(empty($user_id)){
        $response = array('status' => false, 'message' => 'User Id Is Empty', 'response' => (object)array());
		$this->response($response);
    }else if(empty($address)){
        $response = array('status' => false, 'message' => 'Address Is Empty', 'response' => (object)array());
		$this->response($response);
    }else if(empty($latitude)){
        $response = array('status' => false, 'message' => 'Latitude Is Empty', 'response' => (object)array());
		$this->response($response);
    }else if(empty($longitude)){
        $response = array('status' => false, 'message' => 'Longitude Is Empty', 'response' => (object)array());
		$this->response($response);
    }else{
                        $data = array(
                            'address' => $address,
                            'latitude' => $latitude,
                            'longitude' => $longitude,
                            'updated_on' => date('Y-m-d')
                        );
                    $update_user = $this->user_model->common_update('users',$data,array('id' => $user_id));
                    //echo $this->db->last_query();exit;
                    $get_user_details = $this->user_model->common_fetch('users',array('id' => $user_id));
                    if(empty($get_user_details[0])){
                        $response = array('status' => false, 'message' => 'User Address Not Updated', 'response' => (object)array());
		                $this->response($response);
                    }else{
                        $response = array('status' => true, 'message' => 'User Address Updated Successfully', 'response' => $get_user_details[0]);
		                $this->response($response);
                    }
    }
}
/*user location update*/

/*user type update*/
public function user_type_updating_post()
{
    $user_input = $this->client_request;
    extract($user_input);
    if(empty($user_id)){
        $response = array('status' => false, 'message' => 'User Id Is Empty', 'response' => (object)array());
		$this->response($response);
    }else if(empty($user_type)){
        $response = array('status' => false, 'message' => 'User Type Is Empty', 'response' => (object)array());
		$this->response($response);
    }else{
        $get_user_type = $this->user_model->common_fetch('users',array('id' => $user_id));
        //print_r($get_user_type);exit;
        //echo $get_user_type[0]['user_type'];exit;
        if($get_user_type[0]['user_type'] == 1 || $get_user_type[0]['user_type'] == 2){
            $response = array('status' => false, 'message' => 'User Type Already Updated for this user', 'response' => (object)array());
            $this->response($response);

              }else{

                                $data = array(
                                        'user_type' => $user_type,
                                        'updated_on' => date('Y-m-d')
                                );
                                            $update_user = $this->user_model->common_update('users',$data,array('id'=> $user_id));
                                            $get_user_details = $this->user_model->common_fetch('users',array('id' => $user_id));
                                            $response = array('status' => true, 'message' => 'User Type Updated successfully', 'response' => $get_user_details);
                                            $this->response($response);
                    }
    }
}
/*user type update*/

/*user profile update*/
public function edit_profile_post()
{
    $user_input = $this->client_request;
    extract($user_input);
    if(empty($user_id)){
        $response = array('status' => false, 'message' => 'User Id Is Empty', 'response' => (object)array());
		$this->response($response);
    }else if(empty($user_name)){
        $response = array('status' => false, 'message' => 'User Name Is Empty', 'response' => (object)array());
		$this->response($response);
    }else if(empty($user_mobile)){
        $response = array('status' => false, 'message' => 'User Mobile Is Empty', 'response' => (object)array());
		$this->response($response);
    }else if(empty($user_age)){
        $response = array('status' => false, 'message' => 'User Age Is Empty', 'response' => (object)array());
		$this->response($response);
    }else if(empty($user_gender)){
        $response = array('status' => false, 'message' => 'User Gender Is Empty', 'response' => (object)array());
		$this->response($response);
    }else if(empty($user_image)){
        $response = array('status' => false, 'message' => 'User image is empty', 'response' => (object)array());
        $this->response($response);
    }else{
        define('IMAGE_UPLOAD_DIR','uploads/users/');
	        $img = str_replace('data:image/jpeg;base64','',$user_image);
	        $img = str_replace(' ','+',$img);
	        $user_data = base64_decode($img);
	        $user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
	        $success = file_put_contents($user_file,$user_data); 
	        
	        if($success){
	            $data = array(
	                'user_image' => $user_file,
	                'user_name' => ucwords($user_name),
	                'user_mobile' => $user_mobile,
                    'user_age' => $user_age,
                    'user_gender' => ucwords($user_gender),
	                'updated_on' => date('Y-m-d')
	                );
	                $update_user = $this->user_model->common_update('users',$data,array('id' => $user_id));
                    $get_user_details = $this->user_model->common_fetch('users',array('id' => $user_id));
	                 $response = array('status' => true, 'message' => 'User Details Updated successfully', 'response' => $get_user_details);
                     $this->response($response);
	                
	        }else{
	             $response = array('status' => false, 'message' => 'Error In User Details Updating', 'response' => (object)array());
                 $this->response($response);
	        }
    }
}
/*user profile update*/



/*view categories module*/
 public function view_all_categories_get()
 {
    $get_category_detials = $this->user_model->common_fetch('categories',array('delete_status' => '1'));
    // $get_banners = $this->user_model->common_fetch('banners',array('delete_status' => '1'));
    // if(empty($get_banners)){
    //     $details['banners'] = [];
    // }else{
    //     $details['banners'] = $get_banners;
    // }
    
    if(!empty($get_category_detials)){
       // $details['categories'] = $get_category_detials;
        $response = array('status' => true, 'message' => 'All Categories Details Fetched Successfully..! ', 'response' => $get_category_detials);
		$this->response($response);
    }else{
        $response = array('status' => false, 'message' => 'Empty Categories', 'response' => (object)array());
		$this->response($response);
    }
 } 
/*view categories module*/

/*home page baneers and categories*/
public function home_page_banners_categories_get()
{
   $get_category_detials = $this->user_model->common_fetch('categories',array('delete_status' => '1'));
   $get_banners = $this->user_model->common_fetch('banners',array('delete_status' => '1'));
   if(empty($get_banners)){
       $details['banners'] = [];
   }else{
       $details['banners'] = $get_banners;
   }
   
   if(!empty($get_category_detials)){
       $details['categories'] = $get_category_detials;
       $response = array('status' => true, 'message' => 'All Categories Details Fetched Successfully..! ', 'response' => $details);
       $this->response($response);
   }else{
       $response = array('status' => false, 'message' => 'Empty Categories', 'response' => (object)array());
       $this->response($response);
   }
} 
/*home page baneers and categories*/


/*home page api module*/
public function home_page_post()
{
    $user_input = $this->client_request;
    extract($user_input);
    if(empty($user_id)){
        $response = array('status' => false, 'message' => 'User Id Is Empty', 'response' => (object)array());
		$this->response($response);
    }else if(empty($cat_id)){
        $response = array('status' => false, 'message' => 'Category Id Is Empty', 'response' => (object)array());
		$this->response($response);
    }else{
$details = [];
$i = 0;
        //$get_products_detials = $this->user_model->common_fetch('products',array('delete_status' => '1', 'cat_id' => $cat_id));
        $get_products_detials = $this->user_model->products_fetch($cat_id);
        /*fetching cart items*/
          foreach($get_products_detials as $row){
            $get_cart_items = $this->user_model->common_fetch('cart',array('product_id' => $row['product_id'], 'user_id' => $user_id));
            if(empty($get_cart_items[0])){
                $cart_qunatity = '0';
            }else{
                $cart_qunatity = $get_cart_items[0]['quantity'];
                
            }
            $row['cart_qunatity'] = $cart_qunatity;
            $details[$i]['products'] = $row;
            $i++;
          }
          
          
         
        
        /*fetching cart items*/
        if(!empty($get_products_detials)){
            //$details['products'] = $get_products_detials;
            $response = array('status' => true, 'message' => 'Products Details Fetched Successfully...!', 'response' => $details);
            $this->response($response);
        }else{
            $response = array('status' => false, 'message' => 'No Products For That Category', 'response' => (object)array());
		    $this->response($response);
        }
    }
}
/*home page api module*/

/*single page product view*/
public function view_single_product_post()
{
    $user_input = $this->client_request;
    extract($user_input);
    if(empty($user_id))
    {
        $response =array('status' => false, 'message' =>'user id is empty', 'response' => (object)array());
        $this->response($response);
    }else if(empty($product_id)){
        $response =array('status' => false, 'message' =>'Product id is empty', 'response' => (object)array());
        $this->response($response);
    }else{
             /*favourite  product*/
             $get_wishlist = $this->user_model->common_fetch('user_wishlist',array('user_id' => $user_id, 'product_id' => $product_id));
             /*favourite  product*/
        $get_product = $this->user_model->fetch_single_product($product_id);
        if(empty($get_product[0])){

          

            $response = array('status' => false, 'message' => 'No Products for product id', 'response' => (object)array());
            $this->response($response);
        }else{
            if(empty($get_wishlist[0])){
                $get_product[0]['whishlist'] = "0";
            }else{
                $get_product[0]['whishlist'] = "1";
            }
            $response = array('status' => true, 'message' => 'Product Details Fetched Successfully...!', 'response' => $get_product[0]);
            $this->response($response);
        }
        
    }
}
/*single page product view*/

/*user whishlist insert*/
public function user_wishlist_post()
{
    $user_input = $this->client_request;
    extract($user_input);
    if(empty($user_id))
    {
        $response =array('status' => false, 'message' =>'user id is empty', 'response' => (object)array());
        $this->response($response);
    }else if(empty($product_id)){
        $response =array('status' => false, 'message' =>'Product id is empty', 'response' => (object)array());
        $this->response($response);
    }else{
        $get_wishlist = $this->user_model->common_fetch('user_wishlist',array('user_id' => $user_id, 'product_id' => $product_id));
        if(empty($get_wishlist[0]))
        {
        $data = array(
                  'user_id' => $user_id,
                  'product_id' => $product_id,
                  'created_on' => date('Y-m-d')
        );
           $insert_wishlist = $this->user_model->common_insert('user_wishlist',$data);
           $get_wishlist_details = $this->user_model->common_fetch('user_wishlist',array('id' => $insert_wishlist));
           if(empty($get_wishlist_details[0])){
            $response =array('status' => false, 'message' =>'No Product In Wishlist..!', 'response' => (object)array());
            $this->response($response);
           }else{
            $response =array('status' => true, 'message' =>'Product Successfully Added To User Wishlist..!', 'response' => $get_wishlist_details[0]);
            $this->response($response);
           }
       }else{
                $response =array('status' => false, 'message' =>'Product Already In User Wishlist..!', 'response' => (object)array());
                $this->response($response);
       }

    }
}
/*user whishlist insert*/

/*view all wishlist*/
public function view_all_wishlist_products_post()
{
    $user_input = $this->client_request;
    extract($user_input);
    if(empty($user_id))
    {
        $response =array('status' => false, 'message' =>'user id is empty', 'response' => (object)array());
        $this->response($response);
    }else{
        $get_wishlist = $this->user_model->fetch_wishlist_items($user_id);
        if(empty($get_wishlist)){
            $response =array('status' => false, 'message' =>'No Wishlist For The User', 'response' => (object)array());
            $this->response($response);
        }else{
            $response =array('status' => true, 'message' =>'Wishlist Fetched Successfully...!', 'response' => $get_wishlist);
            $this->response($response);
        }
    }
}
/*view all wishlist*/

/*add to cart module*/
public function add_to_cart_post()
{
    $user_input = $this->client_request;
    extract($user_input);
    if(empty($user_id))
    {
        $response =array('status' => false, 'message' =>'user id is empty', 'response' => (object)array());
        $this->response($response);
    }else if(empty($product_id)){
        $response =array('status' => false, 'message' =>'Product id is empty', 'response' => (object)array());
        $this->response($response);
    }else if(empty($quantity)){
        $response =array('status' => false, 'message' =>'Product Quantity is empty', 'response' => (object)array());
        $this->response($response);
    }else{
        $get_cart_items = $this->user_model->common_fetch('cart',array('user_id' => $user_id, 'product_id' => $product_id));
        if(empty($get_cart_items[0])){
            $data = array(
                          'user_id' => $user_id,
                          'product_id' => $product_id,
                          'quantity' => $quantity,
                          'created_on' => date('Y-m-d')
            );
        $insert_cart_items = $this->user_model->common_insert('cart',$data);
        $get_cart_items = $this->user_model->common_fetch('cart',array('id' => $insert_cart_items));
            if(empty($get_cart_items[0])){
                $response =array('status' => false, 'message' =>'No Products In Cart', 'response' => (object)array());
                $this->response($response);
            }else{
                $response =array('status' => false, 'message' =>'Product Successfully Added To Cart', 'response' => $get_cart_items[0]);
                $this->response($response);
            }
        }else{
            $response =array('status' => false, 'message' =>'Product Already In Cart', 'response' => (object)array());
            $this->response($response);
        }

    }
}
/*add to cart module*/

/*cart items*/
public function cart_items_post()
{
    $user_input = $this->client_request;
    extract($user_input);
    if(empty($user_id))
    {
        $response =array('status' => false, 'message' =>'user id is empty', 'response' => (object)array());
        $this->response($response);
    }else{
        $get_cart_items = $this->user_model->get_cart_items($user_id);
        if(empty($get_cart_items)){
            $response =array('status' => false, 'message' =>'Empty Cart Items For User', 'response' => (object)array());
            $this->response($response);
        }else{
                /*total amount of cart items*/
                  foreach($get_cart_items as $row){
                  $total_price += $row['cart_quantity'] * $row['product_price'];
                  }
                /*total amount of cart items*/
                //echo $total_price;exit;
                $get_extra_charges = $this->user_model->common_fetch('prices',array('price_range_from <=' => $total_price, 'price_range_to >=' => $total_price));
                //echo $this->db->last_query();
               //  print_r($get_extra_charges);exit;
               if(!empty($get_extra_charges[0])){
                $deivery_charges = $get_extra_charges[0]['delivery_charges'];
               }
                $details['cart_items'] = $get_cart_items;
                $details['items_total'] = $total_price;
                $details['delivery_charges'] = $deivery_charges;
                $details['total_amount'] = $total_price + $deivery_charges;

                
            $response =array('status' => true, 'message' =>'Cart Items Fetched Successfully', 'response' => $details);
            $this->response($response);
        }

    }
}
/*cart items*/

/*increase cart item quantity*/
public function increase_cart_item_quantity_post()
{
    $user_input = $this->client_request;
    extract($user_input);
    if(empty($user_id))
    {
        $response =array('status' => false, 'message' =>'user id is empty', 'response' => (object)array());
        $this->response($response);
    }else if(empty($product_id)){
        $response =array('status' => false, 'message' =>'Product id is empty', 'response' => (object)array());
        $this->response($response);
    }else{
        $get_cart_items = $this->user_model->common_fetch('cart',array('user_id' => $user_id, 'product_id' => $product_id));
        if(empty($get_cart_items))
        {
            $response =array('status' => false, 'message' =>'Empty Cart Items For User and product', 'response' => (object)array());
            $this->response($response);
        }else{
            $data = array(
                'quantity' => $get_cart_items[0]['quantity'] + 1,
                'created_on' => date('Y-m-d')
            );
            $cart_update = $this->user_model->common_update('cart',$data,array('user_id' => $user_id, 'product_id' => $product_id));
            $get_cart_items = $this->user_model->common_fetch('cart',array('user_id' => $user_id, 'product_id' => $product_id));
            $response =array('status' => true, 'message' =>'Cart Item Quantity Increased By 1', 'response' => $get_cart_items[0]);
            $this->response($response);


        }

    }
}
/*increase cart item quantity*/



/*decrease cart item quantity*/
public function decrease_cart_item_quantity_post()
{
    $user_input = $this->client_request;
    extract($user_input);
    if(empty($user_id))
    {
        $response =array('status' => false, 'message' =>'user id is empty', 'response' => (object)array());
        $this->response($response);
    }else if(empty($product_id)){
        $response =array('status' => false, 'message' =>'Product id is empty', 'response' => (object)array());
        $this->response($response);
    }else{
        $get_cart_items = $this->user_model->common_fetch('cart',array('user_id' => $user_id, 'product_id' => $product_id));
        if(empty($get_cart_items))
        {
            $response =array('status' => false, 'message' =>'Empty Cart Items For User and product', 'response' => (object)array());
            $this->response($response);
        }else{

            if($get_cart_items[0]['quantity'] ==  '1'){

                $delete_cart_item = $this->db->where(array('user_id' => $user_id, 'product_id' => $product_id))->delete('cart');
                $response =array('status' => false, 'message' =>'Item Removed From Cart..!', 'response' => (object)array());
            $this->response($response);

            }else{

           
                        $data = array(
                            'quantity' => $get_cart_items[0]['quantity'] - 1,
                            'created_on' => date('Y-m-d')
                        );
                        $cart_update = $this->user_model->common_update('cart',$data,array('user_id' => $user_id, 'product_id' => $product_id));
                        $get_cart_items = $this->user_model->common_fetch('cart',array('user_id' => $user_id, 'product_id' => $product_id));
                        $response =array('status' => true, 'message' =>'Cart Item Quantity Decreased By 1', 'response' => $get_cart_items[0]);
                        $this->response($response);
                }


        }

    }
}
/*decrease cart item quantity*/

/*remove cart item*/
public function remove_cart_item_post()
{
    $user_input = $this->client_request;
    extract($user_input);
    if(empty($user_id))
    {
        $response =array('status' => false, 'message' =>'user id is empty', 'response' => (object)array());
        $this->response($response);
    }else if(empty($product_id)){
        $response =array('status' => false, 'message' =>'Product id is empty', 'response' => (object)array());
        $this->response($response);
    }else{
        $get_cart_items = $this->user_model->common_fetch('cart',array('user_id' => $user_id, 'product_id' => $product_id));
        if(empty($get_cart_items[0])){
            $response =array('status' => false, 'message' =>'No Product For User In Cart', 'response' => (object)array());
            $this->response($response);
        }else{
                $remove_cart_item = $this->db->where(array('user_id' => $user_id, 'product_id' => $product_id))->delete('cart');
                //echo $this->db->last_query();exit;
                if($remove_cart_item){
                    $response =array('status' => true, 'message' =>'Product Successfully removed From Cart', 'response' => (object)array());
                $this->response($response);
                }else{
                    $response =array('status' => false, 'message' =>'Product Not Removed From Cart', 'response' => (object)array());
                    $this->response($response);
                }
             }
    }
}
/*remove cart item*/

/*offers fetchings*/
public function get_offers_post()
{
    $user_input = $this->client_request;
    extract($user_input);
    if(empty($user_id))
    {
        $response =array('status' => false, 'message' =>'user id is empty', 'response' => (object)array());
        $this->response($response);
    }else{
          $date = date('Y-m-d');
         $get_offers = $this->user_model->common_fetch('offers',array('offfer_start_date <=' => $date, 'offer_end_date >=' => $date));
        //echo $this->db->last_query();
       // print_r($get_offers);exit;
            if(empty($get_offers)){

            }else{
            $response =array('status' => true, 'message' =>'Offers Fetched Successfully', 'response' => $get_offers);
                $this->response($response);
            }
    }
}
/*offers fetchings*/

/*notifications module*/
public function notifications_post()
{
    $user_input = $this->client_request;
    extract($user_input);
    if(empty($user_id))
    {
        $response =array('status' => false, 'message' =>'user id is empty', 'response' => (object)array());
        $this->response($response);
    }else{
        $get_notifications['notifications'] = $this->user_model->common_fetch('notifications',array('delete_status' => '1','notification_access' => $user_id));
        if(!empty($get_notifications['notifications'])){
             $response = array('status' => true, 'message' => 'Notifications fetched successfully', 'response' => $get_notifications);
        $this->response($response);
        }else{
             $response = array('status' => false, 'message' => 'No Notifications for User', 'response' => array());
        $this->response($response);
        }
       
    }
}
/*notification module*/

/* contact us inserting api*/
public function contact_us_post()
{
  $user_input = $this->client_request;
  extract($user_input);

  if(empty($user_id)){
        $response = array('status' => false, 'message' => 'user id is empty', 'response' =>(object)array());
        $this->response($response);
  }else{
      
    if( !empty($email) && !empty($mobile) && !empty($message))
    {
          $data = array (
              'email' => $email,
              'mobile' => $mobile,
              'message' => ucwords($message),
              'user_id	' => $user_id,
              'created_on' => date('Y-m-d') 
          );
         // $insert_contact = $this->user_model->insert_contact_details($data);
         $insert_contact = $this->user_model->common_insert('contact_us',$data);
          $get_contact_details = $this->user_model->common_fetch('contact_us',array('id' => $insert_contact));
          $response = array('status' => true, 'message' => 'Contact us details inserted successfullly', 'response' =>$get_contact_details[0]);
          $this->response($response);
    }else{
        $response = array('status' => false, 'message' => 'form data empty', 'response' =>(object)array());
        $this->response($response);
    }
  }
}
/* contact us inserting api*/


/*fetch near by delivery boys*/
public function near_by_delivery_boys_post()
{
    $user_input = $this->client_request;
  extract($user_input);

  if(empty($user_id)){
        $response = array('status' => false, 'message' => 'user id is empty', 'response' =>(object)array());
        $this->response($response);
  }else{
    $get_contact_details = $this->user_model->common_fetch('users',array('id' => $user_id , 'user_type' => '1' ));
    if(empty($get_contact_details[0])){
        $response = array('status' => false, 'message' => 'no user details with this user id', 'response' =>(object)array());
        $this->response($response);
    }else{
        $get_distance = $this->user_model->common_fetch('distance',array());
        if(!empty($get_distance[0]))
        {
                $data = array(
                    'latitude' => $get_contact_details[0]['latitude'],
                    'longitude' => $get_contact_details[0]['longitude']
                );
                $get_delivery_boys = $this->user_model->get_distance($data);
                //Print_r($get_delivery_boys);exit;
                if(!empty($get_delivery_boys)){
                    $details = [];
                    $i = 0;
                    foreach($get_delivery_boys as $row){
                        if($row['distance'] <= $get_distance[0]['distance']){
                            $distance[$i] = $row;
                            $i++;
                        }

                    }

                    $response = array('status' => true, 'message' => 'Delivery Boys Near You', 'response' =>$distance);
                    $this->response($response);

                }else{
                    $response = array('status' => false, 'message' => 'No Delivery boys near you', 'response' =>(object)array());
                    $this->response($response);
                }
               

        }
    }
  }
}
/*fetch near by delivery boys*/


/*view single delivery boy*/
public function view_delivery_boy_details_post()
{
    $user_input = $this->client_request;
  extract($user_input);

  if(empty($user_id)){
        $response = array('status' => false, 'message' => 'user id is empty', 'response' =>(object)array());
        $this->response($response);
  }else if(empty($delivery_boy_id)){
        $response = array('status' => false, 'message' => 'Delivery Boy id is empty', 'response' =>(object)array());
        $this->response($response);
  }else{
    $get_contact_details = $this->user_model->common_fetch('users',array('id' => $delivery_boy_id , 'user_type' => '2', 'duty_status' => '1'));
    if(empty($get_contact_details[0])){
        $response = array('status' => false, 'message' => 'Delivery Boy is Off Duty', 'response' =>(object)array());
        $this->response($response);
    }else{
        $response = array('status' => true, 'message' => 'Delivery Boy Details', 'response' =>$get_contact_details[0]);
        $this->response($response);
    }
  }
}
/*view single delivery boy*/

/*proceed to buy api */
public function proceed_to_buy_post()
{
    $user_input = $this->client_request;
  extract($user_input);

  if(empty($user_id)){
        $response = array('status' => false, 'message' => 'user id is empty', 'response' =>(object)array());
        $this->response($response);
  }else if(empty($items_total)){
        $response = array('status' => false, 'message' => 'Items Total is Empty', 'response' =>(object)array());
        $this->response($response);
  }else if(empty($delivery_charges)){
    $response = array('status' => false, 'message' => 'Delivery Charges is empty', 'response' =>(object)array());
    $this->response($response);
  }else if(empty($total_amount)){
    $response = array('status' => false, 'message' => 'Total Amount is empty', 'response' =>(object)array());
    $this->response($response);
  }else if(empty($offer_id)){
    $response = array('status' => false, 'message' => 'Offer ID is empty', 'response' =>(object)array());
    $this->response($response);
  }else if(empty($user_upi_id)){
    $response = array('status' => false, 'message' => 'User UPI ID is empty', 'response' =>(object)array());
    $this->response($response);
  }else{
    

     $data = array(
                'user_id' => $user_id,
                'items_total' => $items_total,
                'delivery_charges' => $delivery_charges,
                'total_amount' => $total_amount,
                'offer_id' => $offer_id,
                'user_upi_id' => $user_upi_id,
                'order_date' => date('Y-m-d'),
                'order_time' => date('H:i:s'),
                'created_on' => date('Y-m-d')

     );

     $insert = $this->user_model->common_insert('orders',$data);

     /*user adress*/
     $get_user_address = $this->user_model->common_fetch('users',array('id' => $user_id));
    if(!empty($get_user_address[0])){
        
        $order_address = $get_user_address[0]['address'];
        $latitude = $get_user_address[0]['latitude'];
        $longitude = $get_user_address[0]['longitude'];
        $dataaddress = array(
                        'order_address' => $order_address,
                        'latitude' => $latitude,
                        'longitude' => $longitude,
                    );
            $update_address = $this->user_model->common_update('orders',$dataaddress,array('id' => $insert));
    }

    /*user address*/

     $order_id = sprintf('%04s', $insert);
     $data1 = array(
               'order_id' => 'ORD'.$order_id,
               'updated_on' => date('Y-m-d')
     );
     $update = $this->user_model->common_update('orders',$data1,array('id' => $insert));
     $get_order_details = $this->user_model->common_fetch('orders',array('id' => $insert));
     $fetch_cart_items = $this->user_model->common_fetch('cart',array('user_id' => $user_id));
     foreach($fetch_cart_items as $row1){
          $data2 = array(
               'order_id' => $get_order_details[0]['order_id'],
               'user_id' => $row1['user_id'],
               'product_id' => $row1['product_id'],
               'quantity' => $row1['quantity'], 
               'created_on' => date('Y-m-d')
          );

          $insert_order_items = $this->user_model->common_insert('order_items',$data2);
     }

     $delete = $this->db->where('user_id',$user_id)->delete('cart');
     $response = array('status' => true, 'message' => 'Order Placed Successfully', 'response' =>$get_order_details[0]);
    $this->response($response);
  }
}
/*proceed to buy api*/

/*send request to delivery boy*/
public function send_request_to_delivery_boy_post()
{
    $user_input = $this->client_request;
    extract($user_input);

  if(empty($user_id)){
        $response = array('status' => false, 'message' => 'user id is empty', 'response' =>(object)array());
        $this->response($response);
  }else if(empty($delivery_boy_id)){
    $response = array('status' => false, 'message' => 'Delivery Boy id is empty', 'response' =>(object)array());
    $this->response($response);
  }else if(empty($order_id)){
    $response = array('status' => false, 'message' => 'Order id is empty', 'response' =>(object)array());
    $this->response($response);
  }else{
    $data = array(
                'delivery_boy_id' => $delivery_boy_id,
                'order_status' => 'request_to_delivery_boy',
                'updated_on' => date('Y-m-d')
    );
    $update = $this->user_model->common_update('orders',$data,array('order_id' => $order_id));
    $fetch_order = $this->user_model->common_fetch('orders',array('order_id' => $order_id));
    if(empty($fetch_order[0])){
        $response = array('status' => false, 'message' => 'No Orders with order  id', 'response' =>(object)array());
        $this->response($response);
    }else{
        $response = array('status' => true, 'message' => 'Successfully sent request to delivery boy', 'response' =>$fetch_order[0]);
        $this->response($response);
    }

  }
}
/*send request to delivery boy*/


/*send request to delivery boy*/
public function cancel_request_to_delivery_boy_post()
{
    $user_input = $this->client_request;
    extract($user_input);

  if(empty($user_id)){
        $response = array('status' => false, 'message' => 'user id is empty', 'response' =>(object)array());
        $this->response($response);
  }else if(empty($delivery_boy_id)){
    $response = array('status' => false, 'message' => 'Delivery Boy id is empty', 'response' =>(object)array());
    $this->response($response);
  }else if(empty($order_id)){
    $response = array('status' => false, 'message' => 'Order id is empty', 'response' =>(object)array());
    $this->response($response);
  }else{
    $data = array(
                'delivery_boy_id' => '',
                'order_status' => 'request_cancel_by_user',
                'updated_on' => date('Y-m-d')
    );
    $update = $this->user_model->common_update('orders',$data,array('order_id' => $order_id));
    $fetch_order = $this->user_model->common_fetch('orders',array('order_id' => $order_id));
    if(empty($fetch_order[0])){
        $response = array('status' => false, 'message' => 'No Orders with order  id', 'response' =>(object)array());
        $this->response($response);
    }else{
        $response = array('status' => true, 'message' => 'Successfully canceled request by user', 'response' =>$fetch_order[0]);
        $this->response($response);
    }

  }
}
/*send request to delivery boy*/

/*change delivery address*/
public function change_delivery_address_post()
{
    $user_input = $this->client_request;
    extract($user_input);

  if(empty($user_id)){
        $response = array('status' => false, 'message' => 'user id is empty', 'response' =>(object)array());
        $this->response($response);
  }else if(empty($order_id)){
    $response = array('status' => false, 'message' => 'Delivery Boy id is empty', 'response' =>(object)array());
    $this->response($response);
  }else if(empty($order_address)){
    $response = array('status' => false, 'message' => 'Address is empty', 'response' =>(object)array());
    $this->response($response);
  }else if(empty($latitude)){
    $response = array('status' => false, 'message' => 'Latitude is empty', 'response' =>(object)array());
    $this->response($response);
  }else if(empty($longitude)){
    $response = array('status' => false, 'message' => 'longitude is empty', 'response' =>(object)array());
    $this->response($response);
  }else{
     $data = array(
                'order_address' => $order_address,
                'latitude' => $latitude,
                'longitude' => $longitude,
                'updated_on' => date('Y-m-d')
     );
     $update = $this->user_model->common_update('orders',$data,array('order_id' => $order_id));
    $fetch_order = $this->user_model->common_fetch('orders',array('order_id' => $order_id));
    if(empty($fetch_order[0])){
        $response = array('status' => false, 'message' => 'No Orders with order  id', 'response' =>(object)array());
        $this->response($response);
    }else{
        $response = array('status' => true, 'message' => 'Successfully Address Updated', 'response' =>$fetch_order[0]);
        $this->response($response);
    }
  }
}
/*change delivery address*/

/*upload screen shot*/
public function upload_screen_shot_post()
{
    $user_input = $this->client_request;
    extract($user_input);

  if(empty($user_id)){
        $response = array('status' => false, 'message' => 'user id is empty', 'response' =>(object)array());
        $this->response($response);
  }else if(empty($order_id)){
    $response = array('status' => false, 'message' => 'Delivery Boy id is empty', 'response' =>(object)array());
    $this->response($response);
  }else if(empty($screen_shot)){
    $response = array('status' => false, 'message' => 'Please upload screen shot', 'response' => (object)array());
    $this->response($response);
}else{
    define('IMAGE_UPLOAD_DIR','uploads/screen_shorts/');
        $img = str_replace('data:image/jpeg;base64','',$screen_shot);
        $img = str_replace(' ','+',$img);
        $user_data = base64_decode($img);
        $user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
        $success = file_put_contents($user_file,$user_data); 
        
        if($success){
           // echo $user_file;exit;
            $data = array(
                'screen_shot' => $user_file,
                'order_status' => 'screen_shot_uploaded',
                'updated_on' => date('Y-m-d')
                );
                $update_order = $this->user_model->common_update('orders',$data,array('order_id' => $order_id));
               // echo $this->db->last_query();exit;
                $get_order_details = $this->user_model->common_fetch('orders',array('order_id' => $order_id));
                 $response = array('status' => true, 'message' => 'Screen Shot Uploaded successfully', 'response' => $get_order_details[0]);
                 $this->response($response);
                
        }else{
             $response = array('status' => false, 'message' => 'Error In Screen Shot Uploading', 'response' => (object)array());
             $this->response($response);
        }
}
}
/*upload screen shot*/

/*user orders*/
public function user_orders_post()
{
    $user_input = $this->client_request;
    extract($user_input);

  if(empty($user_id)){
        $response = array('status' => false, 'message' => 'user id is empty', 'response' =>(object)array());
        $this->response($response);
  }else{
    $get_order_details = $this->user_model->common_fetch('orders',array('user_id' => $user_id, 'order_status !=' => 'complaint', 'order_status !=' => 'delivered'));
    //echo $this->db->last_query();exit;
    if(empty($get_order_details)){
        $response = array('status' => false, 'message' => 'No Orders For User', 'response' =>(object)array());
        $this->response($response);
    }else{
        $response = array('status' => true, 'message' => 'Order Details Fetched Successfully', 'response' =>$get_order_details);
        $this->response($response);
    }
  }
}
/*user orders*/

/*orders history*/
public function orders_history_post()
{
    $user_input = $this->client_request;
    extract($user_input);

  if(empty($user_id)){
        $response = array('status' => false, 'message' => 'user id is empty', 'response' =>(object)array());
        $this->response($response);
  }else{
    $get_order_details = $this->user_model->common_fetch('orders',array('user_id' => $user_id, 'order_status' => 'delivered'));
    //echo $this->db->last_query();exit;
    if(empty($get_order_details)){
        $response = array('status' => false, 'message' => 'No Orders For User', 'response' =>(object)array());
        $this->response($response);
    }else{
        $response = array('status' => true, 'message' => 'Order Details Fetched Successfully', 'response' =>$get_order_details);
        $this->response($response);
    }
  }
}
/*orders history*/


/*complaint orders history*/
public function complaint_orders_post()
{
    $user_input = $this->client_request;
    extract($user_input);

  if(empty($user_id)){
        $response = array('status' => false, 'message' => 'user id is empty', 'response' =>(object)array());
        $this->response($response);
  }else{
    $get_order_details = $this->user_model->common_fetch('orders',array('user_id' => $user_id, 'order_status' => 'complaint'));
    //echo $this->db->last_query();exit;
    if(empty($get_order_details)){
        $response = array('status' => false, 'message' => 'No Orders For User', 'response' =>(object)array());
        $this->response($response);
    }else{
        $response = array('status' => true, 'message' => 'Order Details Fetched Successfully', 'response' =>$get_order_details);
        $this->response($response);
    }
  }
}
/*complaint orders history*/


/*view order_details*/
public function viwe_order_details_post()
{
    $user_input = $this->client_request;
    extract($user_input);

  if(empty($user_id)){
        $response = array('status' => false, 'message' => 'user id is empty', 'response' =>(object)array());
        $this->response($response);
  }else if(empty($order_id)){
    $response = array('status' => false, 'message' => 'Order id is empty', 'response' =>(object)array());
    $this->response($response);
  }else{
    $details = [];
    $get_order_details = $this->user_model->get_order_details($order_id);
    $get_order_items = $this->user_model->get_order_items($order_id);
    if(empty($get_order_details[0])){
        $response = array('status' => false, 'message' => 'No Details for Order Id', 'response' =>(object)array());
        $this->response($response);
    }else{
            $details['order'] = $get_order_details; 
            $details['order_items'] = $get_order_items; 

            $response = array('status' => true, 'message' => 'Order Details Fetched Successfully', 'response' =>$details);
            $this->response($response);
    }
  }
}

public function track_order_post()
{
    $user_input = $this->client_request;
    extract($user_input);

  if(empty($user_id)){
        $response = array('status' => false, 'message' => 'user id is empty', 'response' =>(object)array());
        $this->response($response);
  }else if(empty($order_id)){
    $response = array('status' => false, 'message' => 'Order id is empty', 'response' =>(object)array());
    $this->response($response);
  }else{
    $track_order_status = $this->user_model->get_order_status($order_id);
    if(empty($track_order_status[0])){
        $response = array('status' => false, 'message' => 'No Order Status For Order ID', 'response' =>(object)array());
        $this->response($response);
    }else{
        $response = array('status' => true, 'message' => 'Track Order Details Fetched Successfully', 'response' =>$track_order_status[0]);
        $this->response($response);
    }
  }
}
/*view order details*/


/*complaint order*/
public function complaint_order_by_customer_post()
{
    $user_input = $this->client_request;
    extract($user_input);

  if(empty($user_id)){
        $response = array('status' => false, 'message' => 'user id is empty', 'response' =>(object)array());
        $this->response($response);
  }else if(empty($order_id)){
    $response = array('status' => false, 'message' => 'Order id is empty', 'response' =>(object)array());
    $this->response($response);
  }else if(empty($item_name)){
    $response = array('status' => false, 'message' => 'Item Name is empty', 'response' =>(object)array());
    $this->response($response);
  }else if(empty($description)){
    $response = array('status' => false, 'message' => 'Description is empty', 'response' =>(object)array());
    $this->response($response);
  }else if(empty($item_photo)){
    $response = array('status' => false, 'message' => 'please Upload Damaged Item', 'response' =>(object)array());
    $this->response($response);
  }else{
    define('IMAGE_UPLOAD_DIR','uploads/complaints/');
    $img = str_replace('data:image/jpeg;base64','',$item_photo);
    $img = str_replace(' ','+',$img);
    $user_data = base64_decode($img);
    $user_file = IMAGE_UPLOAD_DIR . uniqid() . '.png';
    $success = file_put_contents($user_file,$user_data); 
    
    if($success){
       // echo $user_file;exit;
        $data = array(
            'complaint_item_photo' => $user_file,
            'compaint_item_name' => ucwords($item_name),
            'compalint_description' => ucwords($description),
            'updated_on' => date('Y-m-d')
            );
            $update_order = $this->user_model->common_update('orders',$data,array('order_id' => $order_id));
           // echo $this->db->last_query();exit;
            $get_order_details = $this->user_model->common_fetch('orders',array('order_id' => $order_id));
             $response = array('status' => true, 'message' => 'Complaint Details Added Successfully', 'response' => $get_order_details[0]);
             $this->response($response);
            
    }else{
         $response = array('status' => false, 'message' => 'Error In Photo Uploading', 'response' => (object)array());
         $this->response($response);
    }
  }
}
/*complaint order*/














/*about us content api*/
public function about_us_post()
{
    $user_input = $this->client_request;
    extract($user_input);

  if(empty($user_id)){
        $response = array('status' => false, 'message' => 'user id is empty', 'response' =>(object)array());
        $this->response($response);
  }else{
    $get_about_us = $this->user_model->common_fetch('about_us',array());
   //  Print_r($get_about_us[0]);exit;
    if(empty($get_about_us[0])){
        
        $response = array('status' => false, 'message' => 'No About Us Content', 'response' =>(object)array());
        $this->response($response);
    }else{
        $response = array('status' => true, 'message' => 'About Us Content', 'response' =>$get_about_us[0]);
        $this->response($response);
    }
  }
}
/*about us content api*/

/*terms and conditions content api*/
public function terms_and_conditions_post()
{
    $user_input = $this->client_request;
    extract($user_input);

  if(empty($user_id)){
        $response = array('status' => false, 'message' => 'user id is empty', 'response' =>(object)array());
        $this->response($response);
  }else{
    $get_terms_conditions = $this->user_model->common_fetch('terms_conditions',array());
   //  Print_r($get_about_us[0]);exit;
    if(empty($get_terms_conditions[0])){
        
        $response = array('status' => false, 'message' => 'No Terms And Conditions Content', 'response' =>(object)array());
        $this->response($response);
    }else{
        $response = array('status' => true, 'message' => 'Terms And Conditions Content', 'response' =>$get_terms_conditions[0]);
        $this->response($response);
    }
  }
}
/*terms and conditions content api*/

/*Privacy Policy content api*/
public function privacy_policy_post()
{
    $user_input = $this->client_request;
    extract($user_input);

  if(empty($user_id)){
        $response = array('status' => false, 'message' => 'user id is empty', 'response' =>(object)array());
        $this->response($response);
  }else{
    $get_privacy_policy = $this->user_model->common_fetch('privacy_policy',array());
   //  Print_r($get_about_us[0]);exit;
    if(empty($get_privacy_policy[0])){
        
        $response = array('status' => false, 'message' => 'No Privacy Policy Content', 'response' =>(object)array());
        $this->response($response);
    }else{
        $response = array('status' => true, 'message' => 'Privacy Policy Content', 'response' =>$get_privacy_policy[0]);
        $this->response($response);
    }
  }
}
/*privacy policy content api*/

/*end of a controller*/
}
?>