<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Units extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/userguide3/general/urls.html
	 */

     public function __construct(){ 
        parent::__construct();
        
        $this->load->model('admin/admin_model','admin_model');
        $this->load->library('session');

		if (!($this->session->userdata('admin_id')))
		{
			//$this->load->view('admin/login');
			redirect('admin/login','refresh');
		}
      }

	public function index()
	{
        //echo 'hi';
		// $this->load->view('admin/layout/header');  
        // $this->load->view('admin/categories');
        // $this->load->view('admin/layout/footer');
	}

    public function view_all_units()
    {
         $get_units = $this->admin_model->common_fetch('units',array());
		// print_r($get_categories);exit;
		 $data['units'] = $get_units;
        $this->load->view('admin/layout/header');
        $this->load->view('admin/view_all_units',$data);
        $this->load->view('admin/layout/footer');
    }

	public function add_new_unit()
	{
		/* Load form validation library */ 
		$this->load->library('form_validation');
		/* Set validation rule for name field in the form */ 
		$this->form_validation->set_rules('unit_name', 'unit_name', 'required|alpha');
		//$this->form_validation->set_rules('user_id', 'user_id', 'required|min_length[6]');
		if ($this->form_validation->run() == FALSE)
	   {
		   $this->session->set_flashdata('two','Unit Name Should be in Alphabets Only..!');
			redirect('admin/units/view_all_units', 'refresh');
	   }else{

             $unit_name = ucfirst($this->input->post('unit_name'));
			 $get_units = $this->admin_model->common_fetch('units',array('unit_name' => $unit_name));
			 if(empty($get_units))
			 {

			
						/*-------------category insert-------------*/
						$data = array(
                                 'unit_name' => $unit_name,
								 'created_on' => date('Y-m-d'),
								 'delete_status' => '1'
						);
						$insert = $this->admin_model->common_insert('units',$data);
						if($insert)
						{
							$this->session->set_flashdata('one','Unit Details updated Successfullys..!');
							redirect('admin/units/view_all_units', 'refresh');
						}else{
							$this->session->set_flashdata('two','Unit Details Not updated Successfully..!');
							redirect('admin/units/view_all_units', 'refresh');
						}
						/*--------------category insert------------*/


		}else{
			$this->session->set_flashdata('two','Unit Name Already Created..!');
			redirect('admin/units/view_all_units', 'refresh');
		}

	   }


		
	}


	public function edit_unit($id)
	{
		$get_units = $this->admin_model->common_fetch('units',array('id' => $id));
		// print_r($get_categories);exit;
		 $data['units'] = $get_units;
        $this->load->view('admin/layout/header');
        $this->load->view('admin/edit_unit',$data);
        $this->load->view('admin/layout/footer');
	}

	public function update_unit_details($id)
	{
		/*updating category details-------*/
		$unit_name = ucfirst($this->input->post('unit_name'));
		//$get_categories = $this->admin_model->common_fetch('categories',array('id' => $id));
			 
		// echo $name;exit;
		//print_r($_FILES['image']);exit;
		      $get_units = $this->admin_model->common_fetch('units',array('id' => $id));
				if(count($get_units) == '1')
				{
					//$unlink_amenity = unlink($get_categories['0']['image']);
					$data = array(
						'unit_name' => $unit_name,
						'updated_on' => date('Y-m-d'),
						'delete_status' => '1'
			            );
			   $update = $this->admin_model->common_update('units',$data,array('id' => $id));
				if($update)
                {
                    $this->session->set_flashdata('one','Unit Details Updated Successfully..!');
                    redirect('admin/units/view_all_units/', 'refresh');
                }else{
                    $this->session->set_flashdata('two','Unit Details Not Updated Successfully..!');
                    redirect('admin/units/edit_unit/'.$id.'', 'refresh');
                }
	  

			

		}else{
			$this->session->set_flashdata('two','Category Details Not Updated Successfully..!');
			redirect('admin/units/edit_unit/'.$id.'', 'refresh');
		}

			
			// else{
			// 			$this->session->set_flashdata('two','Please Upload Category Image..!');
			// 			redirect('admin/categories/edit_category/'.$id.'', 'refresh');
			// }
		/*------updating category details---*/
	}


	public function update_unit()
	{
		$id = $this->input->post('id');
	    $status = $this->input->post('status');
	    
	    if($status == '1')
	    {
	        $status = '0';
	    }else{
	       $status = '1'; 
	    }
	    
	       $data = array(
	            'delete_status' => $status,
	            'updated_on' => date('Y-m-d')
	            );
	            
	           // echo $amenity.$id;exit;
	            $update_unit = $this->admin_model->common_update('units',$data,array('id' => $id));
	            
	    echo json_encode($update_unit);
		//echo $this->db->last_query();
				exit;
	}

	public function delete_unit($id)
	{
	    $get_units = $this->admin_model->common_fetch('units',array('id' => $id));
	    
	    $delete = $this->db->delete('units',array('id'=>$id));
	     if($delete)
	     {
	         $this->session->set_flashdata('one','Unit Details Deleted Successfully..!');
                  redirect('admin/units/view_all_units', 'refresh');
	     }else{
	         $this->session->set_flashdata('two','Unit Details Not Deleted..!');
                  redirect('admin/units/view_all_units/', 'refresh');
	     }
	}

    


   
	
	


}
