<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Products extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/userguide3/general/urls.html
	 */

     public function __construct(){
        parent::__construct();
        
        $this->load->model('admin/admin_model','admin_model');
        $this->load->library('session');

		if (!($this->session->userdata('admin_id')))
		{
			//$this->load->view('admin/login');
			redirect('admin/login','refresh');
		}
      }

	public function index()
	{
		// $this->load->view('admin/layout/header');
        // $this->load->view('admin/dashboard');
        // $this->load->view('admin/layout/footer');
	}

    public function view_all_products()
    {
        $get_products = $this->admin_model->products_fetch();
		// print_r($get_categories);exit;
		 $data['products'] = $get_products;
        $this->load->view('admin/layout/header');
        $this->load->view('admin/view_all_products',$data);
        $this->load->view('admin/layout/footer');
    }

    public function add_new_product()
    {
		$get_categories = $this->admin_model->common_fetch('categories',array());
		// print_r($get_categories);exit;
		 $data['categories'] = $get_categories;
		 $get_units = $this->admin_model->common_fetch('units',array());
		 $data['units'] = $get_units;
        $this->load->view('admin/layout/header');
        $this->load->view('admin/add_new_product',$data);
        $this->load->view('admin/layout/footer');
    }

	public function insert_new_product()
	{
		/* Load form validation library */ 
		$this->load->library('form_validation');
		/* Set validation rule for name field in the form */ 
		$this->form_validation->set_rules('cat_id', 'cat_id', 'required|trim');
		$this->form_validation->set_rules('product_name', 'product_name', 'required|trim');
		$this->form_validation->set_rules('product_quantity', 'product_quantity', 'required|trim');
		$this->form_validation->set_rules('unit_id', 'unit_id', 'required|trim');
		$this->form_validation->set_rules('product_price', 'product_price', 'required|trim');
		if ($this->form_validation->run() == FALSE)
	   {
		   $this->session->set_flashdata('two','Please Fill All Required Details..!');
			redirect('admin/products/add_new_product', 'refresh');
	   }else{

             $cat_id = $this->input->post('cat_id');
			 $product_name = ucfirst($this->input->post('product_name'));
			 $product_quantity = $this->input->post('product_quantity');
			 $unit_id = $this->input->post('unit_id');
			 $product_price = $this->input->post('product_price');
			 $get_products = $this->admin_model->common_fetch('products',array('product_name' => $product_name));
			 if(empty($get_products))
			 {

			 
			// echo $name;exit;
			//print_r($_FILES['image']);exit;
		   /*----------imageupload-----------------*/
				   $this->load->library('upload');

				if (!empty($_FILES['product_image']['name']))
				{
					$config['upload_path'] = './uploads/products/';
					$config['allowed_types'] = 'jpg|png|jpeg';   
					$config['file_name']  = time();
		
					$this->upload->initialize($config);
					if ($this->upload->do_upload('product_image'))
					{
						$img = $this->upload->data();
						$file_name = $img['file_name'];
						$product_image = 'uploads/products/'.$file_name;
                    
						/*-------------category insert-------------*/
						$data = array(
                                 'cat_id' => $cat_id,
								 'product_name' => $product_name,
								 'product_image' => $product_image,
								 'product_quantity' => $product_quantity,
								 'unit_id' => $unit_id,
								 'product_price' => $product_price,
								 'created_on' => date('Y-m-d'),
								 'delete_status' => '1'
						);
						$insert = $this->admin_model->common_insert('products',$data);
						if($insert)
						{
							$this->session->set_flashdata('one','Product Details Added Sucessfully..!');
							redirect('admin/products/view_all_products', 'refresh');
						}else{
							$this->session->set_flashdata('two','Category Name Should be in Alphabets Only..!');
							redirect('admin/products/add_new_product', 'refresh');
						}
						/*--------------category insert------------*/

					}
				}else{
					        $this->session->set_flashdata('two','Please Upload Product Image..!');
							redirect('admin/products/add_new_product', 'refresh');
				}

         /*----------imageupload-----------------*/

		}else{
			$this->session->set_flashdata('two','Product Name Already Created..!');
			redirect('admin/products/add_new_product', 'refresh');
		}

	   }
	}

	public function edit_product($id)
	{
		$get_products = $this->admin_model->common_fetch('products',array('id' => $id));
		// print_r($get_categories);exit;
		 $data['products'] = $get_products;

		 $get_categories = $this->admin_model->common_fetch('categories',array());
		// print_r($get_categories);exit;
		 $data['categories'] = $get_categories;
		 $get_units = $this->admin_model->common_fetch('units',array());
		 $data['units'] = $get_units;
        $this->load->view('admin/layout/header');
        $this->load->view('admin/edit_product',$data);
        $this->load->view('admin/layout/footer');
	}

	public function update_product_details($id)
	{
		/*updating category details-------*/
		
		$cat_id = $this->input->post('cat_id');
		$product_name = ucfirst($this->input->post('product_name'));
		$product_quantity = $this->input->post('product_quantity');
		$unit_id = $this->input->post('unit_id');
		$product_price = $this->input->post('product_price');
		// echo $name;exit;
		//print_r($_FILES['image']);exit;
		      $get_products = $this->admin_model->common_fetch('products',array('id' => $id));
				if(count($get_products) == '1')
				{
					//$unlink_amenity = unlink($get_categories['0']['image']);
					$data = array(
						'cat_id' => $cat_id,
						'product_name' => $product_name,
						'product_quantity' => $product_quantity,
						'unit_id' => $unit_id,
						'product_price' => $product_price,
						'updated_on' => date('Y-m-d'),
						'delete_status' => '1'
			            );
			   $update = $this->admin_model->common_update('products',$data,array('id' => $id));
				
	   /*----------imageupload-----------------*/
			   $this->load->library('upload');

			if (!empty($_FILES['product_image']['name']))
			{
				if(count($get_products) == '1')
				{
					$unlink_amenity = unlink($get_products['0']['product_image']);
				
				}
				
				$config['upload_path'] = './uploads/products/';
				$config['allowed_types'] = 'jpg|png|jpeg';   
				$config['file_name']  = time();
	
				$this->upload->initialize($config);
				if ($this->upload->do_upload('product_image'))
				{
					$img = $this->upload->data();
					$file_name = $img['file_name'];
					$product_image = 'uploads/products/'.$file_name;
				
					/*-------------category insert-------------*/

					


					$data1 = array(
							 
							 'product_image' => $product_image,
							 'updated_on' => date('Y-m-d'),
							 'delete_status' => '1'
					);
					$update = $this->admin_model->common_update('products',$data1,array('id' => $id));
					if($update)
					{
						$this->session->set_flashdata('one','Product Details updated Successfully..!');
						redirect('admin/products/view_all_products', 'refresh');
					}else{
						$this->session->set_flashdata('two','Product Details Not Updated Successfully..!');
						redirect('admin/products/edit_product/'.$id.'', 'refresh');
					}
					/*--------------category insert------------*/

				}else{
					$this->session->set_flashdata('two','Product Image Not Updated Successfully..!');
						redirect('admin/products/edit_product/'.$id.'', 'refresh');
				}

			}

		}else{
			$this->session->set_flashdata('two','Product Details Not Updated Successfully..!');
			redirect('admin/products/edit_product/'.$id.'', 'refresh');
		}

			
			// else{
			// 			$this->session->set_flashdata('two','Please Upload Category Image..!');
			// 			redirect('admin/categories/edit_category/'.$id.'', 'refresh');
			// }
		/*------updating category details---*/
	}


	public function update_product()
	{
		$id = $this->input->post('id');
	    $status = $this->input->post('status');
	    
	    if($status == '1')
	    {
	        $status = '0';
	    }else{
	       $status = '1'; 
	    }
	    
	       $data = array(
	            'delete_status' => $status,
	            'updated_on' => date('Y-m-d')
	            );
	            
	           // echo $amenity.$id;exit;
	            $update_product = $this->admin_model->common_update('products',$data,array('id' => $id));
	            
	    echo json_encode($update_product);
		//echo $this->db->last_query();
				exit;
	}

	public function delete_product($id)
	{
	    $get_products = $this->admin_model->common_fetch('products',array('id' => $id));
	    
	    $delete = $this->db->delete('products',array('id'=>$id));
	     $unlink_product = unlink($get_products['0']['product_image']);
	     if($delete)
	     {
	         $this->session->set_flashdata('one','Product Details Deleted Successfully..!');
                  redirect('admin/products/view_all_products', 'refresh');
	     }else{
	         $this->session->set_flashdata('two','Product Details Not Deleted..!');
                  redirect('admin/products/view_all_products/'.$id.'', 'refresh');
	     }
	}

    


   
	
	


}
