<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Categories extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/userguide3/general/urls.html
	 */

     public function __construct(){ 
        parent::__construct();
        
        $this->load->model('admin/admin_model','admin_model');
        $this->load->library('session');

		if (!($this->session->userdata('admin_id')))
		{
			//$this->load->view('admin/login');
			redirect('admin/login','refresh');
		}
      }

	public function index()
	{
        //echo 'hi';
		// $this->load->view('admin/layout/header');  
        // $this->load->view('admin/categories');
        // $this->load->view('admin/layout/footer');
	}

    public function view_all_categories()
    {
         $get_categories = $this->admin_model->common_fetch('categories',array());
		// print_r($get_categories);exit;
		 $data['categories'] = $get_categories;
        $this->load->view('admin/layout/header');
        $this->load->view('admin/view_all_categories',$data);
        $this->load->view('admin/layout/footer');
    }

	public function add_new_category()
	{
		/* Load form validation library */ 
		$this->load->library('form_validation');
		/* Set validation rule for name field in the form */ 
		$this->form_validation->set_rules('category_name', 'category_name', 'required|alpha');
		//$this->form_validation->set_rules('user_id', 'user_id', 'required|min_length[6]');
		if ($this->form_validation->run() == FALSE)
	   {
		   $this->session->set_flashdata('two','Category Name Should be in Alphabets Only..!');
			redirect('admin/categories/view_all_categories', 'refresh');
	   }else{

             $category_name = ucfirst($this->input->post('category_name'));
			 $get_categories = $this->admin_model->common_fetch('categories',array('category_name' => $category_name));
			 if(empty($get_categories))
			 {

			 
			// echo $name;exit;
			//print_r($_FILES['image']);exit;
		   /*----------imageupload-----------------*/
				   $this->load->library('upload');

				if (!empty($_FILES['category_image']['name']))
				{
					$config['upload_path'] = './uploads/categories/';
					$config['allowed_types'] = 'jpg|png|jpeg';   
					$config['file_name']  = time();
		
					$this->upload->initialize($config);
					if ($this->upload->do_upload('category_image'))
					{
						$img = $this->upload->data();
						$file_name = $img['file_name'];
						$category_image = 'uploads/categories/'.$file_name;
                    
						/*-------------category insert-------------*/
						$data = array(
                                 'category_name' => $category_name,
								 'category_image' => $category_image,
								 'created_on' => date('Y-m-d'),
								 'delete_status' => '1'
						);
						$insert = $this->admin_model->common_insert('categories',$data);
						if($insert)
						{
							$this->session->set_flashdata('one','Category Details updated Successfullys..!');
							redirect('admin/categories/view_all_categories', 'refresh');
						}else{
							$this->session->set_flashdata('two','Category Details Not updated Successfully..!');
							redirect('admin/categories/view_all_categories', 'refresh');
						}
						/*--------------category insert------------*/

					}else{
						$this->session->set_flashdata('two','Category Image Not Uploadeed Successfully..!');
							redirect('admin/categories/view_all_categories', 'refresh');
					}
				}else{
					        $this->session->set_flashdata('two','Please Upload Category Image..!');
							redirect('admin/categories/view_all_categories', 'refresh');
				}

         /*----------imageupload-----------------*/

		}else{
			$this->session->set_flashdata('two','Category Name Already Created..!');
			redirect('admin/categories/view_all_categories', 'refresh');
		}

	   }


		
	}


	public function edit_category($id)
	{
		$get_categories = $this->admin_model->common_fetch('categories',array('id' => $id));
		// print_r($get_categories);exit;
		 $data['categories'] = $get_categories;
        $this->load->view('admin/layout/header');
        $this->load->view('admin/edit_category',$data);
        $this->load->view('admin/layout/footer');
	}

	public function update_category_details($id)
	{
		/*updating category details-------*/
		$category_name = ucfirst($this->input->post('category_name'));
		//$get_categories = $this->admin_model->common_fetch('categories',array('id' => $id));
			 
		// echo $name;exit;
		//print_r($_FILES['image']);exit;
		      $get_categories = $this->admin_model->common_fetch('categories',array('id' => $id));
				if(count($get_categories) == '1')
				{
					//$unlink_amenity = unlink($get_categories['0']['image']);
					$data = array(
						'category_name' => $category_name,
						'updated_on' => date('Y-m-d'),
						'delete_status' => '1'
			            );
			   $update = $this->admin_model->common_update('categories',$data,array('id' => $id));
				
	   /*----------imageupload-----------------*/
			   $this->load->library('upload');

			if (!empty($_FILES['category_image']['name']))
			{
				if(count($get_categories) == '1')
				{
					$unlink_amenity = unlink($get_categories['0']['category_image']);
				
				}
				
				$config['upload_path'] = './uploads/categories/';
				$config['allowed_types'] = 'jpg|png|jpeg';   
				$config['file_name']  = time();
	
				$this->upload->initialize($config);
				if ($this->upload->do_upload('category_image'))
				{
					$img = $this->upload->data();
					$file_name = $img['file_name'];
					$category_image = 'uploads/categories/'.$file_name;
				
					/*-------------category insert-------------*/
					$data1 = array(
							 
							 'category_image' => $category_image,
							 'created_on' => date('Y-m-d'),
							 'delete_status' => '1'
					);
					$insert = $this->admin_model->common_update('categories',$data1,array('id' => $id));
					if($insert)
					{
						$this->session->set_flashdata('one','Category Details updated Successfully..!');
						redirect('admin/categories/view_all_categories', 'refresh');
					}else{
						$this->session->set_flashdata('two','Category Details Not Updated Successfully..!');
						redirect('admin/categories/edit_category/'.$id.'', 'refresh');
					}
					/*--------------category insert------------*/

				}else{
					$this->session->set_flashdata('two','Category Image Not Updated Successfully..!');
						redirect('admin/categories/edit_category/'.$id.'', 'refresh');
				}

			}else{
				$this->session->set_flashdata('one','Category Details Updated Successfully..!');
						redirect('admin/categories/view_all_categories/', 'refresh');
			}

		}else{
			$this->session->set_flashdata('two','Category Details Not Updated Successfully..!');
			redirect('admin/categories/view_all_categories/', 'refresh');
		}

			
			// else{
			// 			$this->session->set_flashdata('two','Please Upload Category Image..!');
			// 			redirect('admin/categories/edit_category/'.$id.'', 'refresh');
			// }
		/*------updating category details---*/
	}


	public function update_category()
	{
		$id = $this->input->post('id');
	    $status = $this->input->post('status');
	    
	    if($status == '1')
	    {
	        $status = '0';
	    }else{
	       $status = '1'; 
	    }
	    
	       $data = array(
	            'delete_status' => $status,
	            'updated_on' => date('Y-m-d')
	            );
	            
	           // echo $amenity.$id;exit;
	            $update_category = $this->admin_model->common_update('categories',$data,array('id' => $id));
	            
	    echo json_encode($update_category);
		//echo $this->db->last_query();
				exit;
	}

	public function delete_category($id)
	{
	    $get_categories = $this->admin_model->common_fetch('categories',array('id' => $id));
	    
	    $delete = $this->db->delete('categories',array('id'=>$id));
	     $unlink_category = unlink($get_categories['0']['category_image']);
	     if($delete)
	     {
	         $this->session->set_flashdata('one','Category Details Deleted Successfully..!');
                  redirect('admin/categories/view_all_categories', 'refresh');
	     }else{
	         $this->session->set_flashdata('two','Category Details Not Deleted..!');
                  redirect('admin/categories/edit_category/'.$id.'', 'refresh');
	     }
	}

    


   
	
	


}
